/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.Dataset;
import edu.stanford.nlp.classify.LinearClassifierFactory;
import edu.stanford.nlp.classify.ProbabilisticClassifier;
import edu.stanford.nlp.classify.RVFClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.BasicDatum;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.Distribution;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.FixedPrioritiesPriorityQueue;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Triple;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LinearClassifier<L, F>
implements ProbabilisticClassifier<L, F>,
RVFClassifier<L, F> {
    private double[][] weights;
    private Index<L> labelIndex;
    private Index<F> featureIndex;
    public boolean intern = false;
    private double[] thresholds = null;
    private static final long serialVersionUID = 8499574525453275255L;
    private static final int MAX_FEATURE_ALIGN_WIDTH = 50;
    public static final String TEXT_SERIALIZATION_DELIMITER = "\t";

    @Override
    public Collection<L> labels() {
        return this.labelIndex.objectsList();
    }

    public Collection<F> features() {
        return this.featureIndex.objectsList();
    }

    public Index<L> labelIndex() {
        return this.labelIndex;
    }

    public Index<F> featureIndex() {
        return this.featureIndex;
    }

    private double weight(int iFeature, int iLabel) {
        if (iFeature < 0) {
            return 0.0;
        }
        assert (iFeature < this.weights.length);
        assert (iLabel < this.weights[iFeature].length);
        return this.weights[iFeature][iLabel];
    }

    private double weight(F feature, int iLabel) {
        int f = this.featureIndex.indexOf(feature);
        return this.weight(f, iLabel);
    }

    public double weight(F feature, L label) {
        int f = this.featureIndex.indexOf(feature);
        int iLabel = this.labelIndex.indexOf(label);
        return this.weight(f, iLabel);
    }

    @Override
    public Counter<L> scoresOf(Datum<L, F> example) {
        if (example instanceof RVFDatum) {
            return this.scoresOfRVFDatum((RVFDatum)example);
        }
        Collection feats = example.asFeatures();
        int[] features = new int[feats.size()];
        int i = 0;
        for (Object f : feats) {
            int index = this.featureIndex.indexOf(f);
            if (index < 0) continue;
            features[i++] = index;
        }
        int[] activeFeatures = new int[i];
        System.arraycopy(features, 0, activeFeatures, 0, i);
        ClassicCounter<L> scores = new ClassicCounter<L>();
        for (L lab : this.labels()) {
            scores.setCount(lab, this.scoreOf(activeFeatures, lab));
        }
        return scores;
    }

    public Counter<L> scoresOf(int[] features) {
        ClassicCounter<L> scores = new ClassicCounter<L>();
        for (L label : this.labels()) {
            scores.setCount(label, this.scoreOf(features, label));
        }
        return scores;
    }

    public double scoreOf(Datum<L, F> example, L label) {
        if (example instanceof RVFDatum) {
            return this.scoreOfRVFDatum((RVFDatum)example, label);
        }
        int iLabel = this.labelIndex.indexOf(label);
        double score = 0.0;
        for (Object f : example.asFeatures()) {
            score += this.weight(f, (L)iLabel);
        }
        return score + this.thresholds[iLabel];
    }

    @Override
    @Deprecated
    public Counter<L> scoresOf(RVFDatum<L, F> example) {
        ClassicCounter<L> scores = new ClassicCounter<L>();
        for (L l : this.labels()) {
            scores.setCount(l, this.scoreOf(example, l));
        }
        return scores;
    }

    private Counter<L> scoresOfRVFDatum(RVFDatum<L, F> example) {
        ClassicCounter<L> scores = new ClassicCounter<L>();
        for (L l : this.labels()) {
            scores.setCount(l, this.scoreOfRVFDatum(example, l));
        }
        return scores;
    }

    @Deprecated
    public double scoreOf(RVFDatum<L, F> example, L label) {
        int iLabel = this.labelIndex.indexOf(label);
        double score = 0.0;
        Counter<F> features = example.asFeaturesCounter();
        for (F f : features.keySet()) {
            score += this.weight(f, (L)iLabel) * features.getCount(f);
        }
        return score + this.thresholds[iLabel];
    }

    private double scoreOfRVFDatum(RVFDatum<L, F> example, L label) {
        int iLabel = this.labelIndex.indexOf(label);
        double score = 0.0;
        Counter<F> features = example.asFeaturesCounter();
        for (F f : features.keySet()) {
            score += this.weight(f, (L)iLabel) * features.getCount(f);
        }
        return score + this.thresholds[iLabel];
    }

    private double scoreOf(int[] feats, L label) {
        assert (this.labelIndex.indexOf(label, false) >= 0);
        int iLabel = this.labelIndex.indexOf(label);
        double score = 0.0;
        for (int feat : feats) {
            score += this.weight(feat, iLabel);
        }
        return score + this.thresholds[iLabel];
    }

    @Override
    public Counter<L> probabilityOf(Datum<L, F> example) {
        if (example instanceof RVFDatum) {
            return this.probabilityOfRVFDatum((RVFDatum)example);
        }
        Counter<L> scores = this.logProbabilityOf(example);
        for (L label : scores.keySet()) {
            scores.setCount(label, Math.exp(scores.getCount(label)));
        }
        return scores;
    }

    private Counter<L> probabilityOfRVFDatum(RVFDatum<L, F> example) {
        Counter<L> scores = this.logProbabilityOfRVFDatum(example);
        for (L label : scores.keySet()) {
            scores.setCount(label, Math.exp(scores.getCount(label)));
        }
        return scores;
    }

    @Override
    @Deprecated
    public Counter<L> probabilityOf(RVFDatum<L, F> example) {
        Counter<L> scores = this.logProbabilityOf(example);
        for (L label : scores.keySet()) {
            scores.setCount(label, Math.exp(scores.getCount(label)));
        }
        return scores;
    }

    @Override
    public Counter<L> logProbabilityOf(Datum<L, F> example) {
        if (example instanceof RVFDatum) {
            return this.logProbabilityOfRVFDatum((RVFDatum)example);
        }
        Counter<L> scores = this.scoresOf(example);
        Counters.logNormalizeInPlace(scores);
        return scores;
    }

    public Counter<L> logProbabilityOf(int[] features) {
        Counter<L> scores = this.scoresOf(features);
        Counters.logNormalizeInPlace(scores);
        return scores;
    }

    public Counter<L> probabilityOf(int[] features) {
        Counter<L> scores = this.logProbabilityOf(features);
        for (L label : scores.keySet()) {
            scores.setCount(label, Math.exp(scores.getCount(label)));
        }
        return scores;
    }

    private Counter<L> logProbabilityOfRVFDatum(RVFDatum<L, F> example) {
        Counter<L> scores = this.scoresOfRVFDatum(example);
        Counters.logNormalizeInPlace(scores);
        return scores;
    }

    @Override
    @Deprecated
    public Counter<L> logProbabilityOf(RVFDatum<L, F> example) {
        Counter<L> scores = this.scoresOf(example);
        Counters.logNormalizeInPlace(scores);
        return scores;
    }

    protected Set<Integer> getLabelIndices(Set<L> labels) {
        Set<Integer> iLabels = Generics.newHashSet();
        for (L label : labels) {
            int iLabel = this.labelIndex.indexOf(label);
            iLabels.add(iLabel);
            if (iLabel >= 0) continue;
            throw new IllegalArgumentException("Unknown label " + label);
        }
        return iLabels;
    }

    public int getFeatureCount(double threshold, boolean useMagnitude) {
        int n = 0;
        double[][] arr$ = this.weights;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[] weightArray;
            for (double weight : weightArray = arr$[i$]) {
                double thisWeight;
                double d = thisWeight = useMagnitude ? Math.abs(weight) : weight;
                if (!(thisWeight > threshold)) continue;
                ++n;
            }
        }
        return n;
    }

    public int getFeatureCount(Set<L> labels, double threshold, boolean useMagnitude) {
        if (labels != null) {
            Set<Integer> iLabels = this.getLabelIndices(labels);
            return this.getFeatureCountLabelIndices(iLabels, threshold, useMagnitude);
        }
        return this.getFeatureCount(threshold, useMagnitude);
    }

    protected int getFeatureCountLabelIndices(Set<Integer> iLabels, double threshold, boolean useMagnitude) {
        int n = 0;
        for (double[] weightArray : this.weights) {
            for (int labIndex : iLabels) {
                double d = useMagnitude ? Math.abs(weightArray[labIndex]) : weightArray[labIndex];
                double thisWeight = d;
                if (!(thisWeight > threshold)) continue;
                ++n;
            }
        }
        return n;
    }

    public List<Triple<F, L, Double>> getTopFeatures(double threshold, boolean useMagnitude, int numFeatures) {
        return this.getTopFeatures(null, threshold, useMagnitude, numFeatures, true);
    }

    public List<Triple<F, L, Double>> getTopFeatures(Set<L> labels, double threshold, boolean useMagnitude, int numFeatures, boolean descending) {
        if (labels != null) {
            Set<Integer> iLabels = this.getLabelIndices(labels);
            return this.getTopFeaturesLabelIndices(iLabels, threshold, useMagnitude, numFeatures, descending);
        }
        return this.getTopFeaturesLabelIndices(null, threshold, useMagnitude, numFeatures, descending);
    }

    protected List<Triple<F, L, Double>> getTopFeaturesLabelIndices(Set<Integer> iLabels, double threshold, boolean useMagnitude, int numFeatures, boolean descending) {
        FixedPrioritiesPriorityQueue<Pair<Integer, Integer>> biggestKeys = new FixedPrioritiesPriorityQueue<Pair<Integer, Integer>>();
        for (int feat = 0; feat < this.weights.length; ++feat) {
            for (int lab = 0; lab < this.weights[feat].length; ++lab) {
                double thisWeight;
                if (iLabels != null && !iLabels.contains(lab) || !((thisWeight = useMagnitude ? Math.abs(this.weights[feat][lab]) : this.weights[feat][lab]) > threshold)) continue;
                thisWeight = -thisWeight;
                if (biggestKeys.size() == numFeatures) {
                    double lowest = biggestKeys.getPriority();
                    if (!(thisWeight < lowest)) continue;
                    biggestKeys.removeFirst();
                    biggestKeys.add(new Pair<Integer, Integer>(feat, lab), thisWeight);
                    continue;
                }
                biggestKeys.add(new Pair<Integer, Integer>(feat, lab), thisWeight);
            }
        }
        ArrayList<Triple<F, L, Double>> topFeatures = new ArrayList<Triple<F, L, Double>>(biggestKeys.size());
        while (!biggestKeys.isEmpty()) {
            Pair p = (Pair)biggestKeys.removeFirst();
            double weight = this.weights[(Integer)p.first()][(Integer)p.second()];
            F feat = this.featureIndex.get((Integer)p.first());
            L label = this.labelIndex.get((Integer)p.second());
            topFeatures.add(new Triple<F, L, Double>(feat, label, weight));
        }
        if (descending) {
            Collections.reverse(topFeatures);
        }
        return topFeatures;
    }

    public String topFeaturesToString(List<Triple<F, L, Double>> topFeatures) {
        int maxLeng = 0;
        for (Triple<F, L, Double> t : topFeatures) {
            String key = "(" + t.first + "," + t.second + ")";
            int leng = key.length();
            if (leng <= maxLeng) continue;
            maxLeng = leng;
        }
        maxLeng = Math.min(64, maxLeng);
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(4);
        nf.setMaximumFractionDigits(4);
        if (nf instanceof DecimalFormat) {
            ((DecimalFormat)nf).setPositivePrefix(" ");
        }
        StringBuilder sb = new StringBuilder();
        for (Triple<F, L, Double> t : topFeatures) {
            String key = "(" + t.first + "," + t.second + ")";
            sb.append(StringUtils.pad(key, maxLeng));
            sb.append(" ");
            double cnt = t.third();
            if (Double.isInfinite(cnt)) {
                sb.append(cnt);
            } else {
                sb.append(nf.format(cnt));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toBiggestWeightFeaturesString(boolean useMagnitude, int numFeatures, boolean printDescending) {
        int j;
        FixedPrioritiesPriorityQueue<Pair<Integer, Integer>> biggestKeys = new FixedPrioritiesPriorityQueue<Pair<Integer, Integer>>();
        for (int feat = 0; feat < this.weights.length; ++feat) {
            for (int lab = 0; lab < this.weights[feat].length; ++lab) {
                double thisWeight = useMagnitude ? -Math.abs(this.weights[feat][lab]) : -this.weights[feat][lab];
                if (biggestKeys.size() == numFeatures) {
                    double lowest = biggestKeys.getPriority();
                    if (!(thisWeight < lowest)) continue;
                    biggestKeys.removeFirst();
                    biggestKeys.add(new Pair<Integer, Integer>(feat, lab), thisWeight);
                    continue;
                }
                biggestKeys.add(new Pair<Integer, Integer>(feat, lab), thisWeight);
            }
        }
        int actualSize = biggestKeys.size();
        Pair[] bigArray = (Pair[])ErasureUtils.mkTArray(Pair.class, actualSize);
        if (printDescending) {
            for (j = actualSize - 1; j >= 0; --j) {
                bigArray[j] = (Pair)biggestKeys.removeFirst();
            }
        } else {
            for (j = 0; j < actualSize; --j) {
                bigArray[j] = (Pair)biggestKeys.removeFirst();
            }
        }
        List<Pair> bigColl = Arrays.asList(bigArray);
        int maxLeng = 0;
        for (Pair p : bigColl) {
            String key = "(" + this.featureIndex.get((Integer)p.first) + "," + this.labelIndex.get((Integer)p.second) + ")";
            int leng = key.length();
            if (leng <= maxLeng) continue;
            maxLeng = leng;
        }
        maxLeng = Math.min(64, maxLeng);
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(4);
        nf.setMaximumFractionDigits(4);
        if (nf instanceof DecimalFormat) {
            ((DecimalFormat)nf).setPositivePrefix(" ");
        }
        StringBuilder sb = new StringBuilder("LinearClassifier [printing top " + numFeatures + " features]\n");
        for (Pair p : bigColl) {
            String key = "(" + this.featureIndex.get((Integer)p.first) + "," + this.labelIndex.get((Integer)p.second) + ")";
            sb.append(StringUtils.pad(key, maxLeng));
            sb.append(" ");
            double cnt = this.weights[(Integer)p.first][(Integer)p.second];
            if (Double.isInfinite(cnt)) {
                sb.append(cnt);
            } else {
                sb.append(nf.format(cnt));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toDistributionString(int threshold) {
        ClassicCounter<Double> weightCounts = new ClassicCounter<Double>();
        StringBuilder s = new StringBuilder();
        s.append("Total number of weights: ").append(this.totalSize());
        double[][] arr$ = this.weights;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[] weightArray;
            for (double weight : weightArray = arr$[i$]) {
                weightCounts.incrementCount(weight);
            }
        }
        s.append("Counts of weights\n");
        Set keys = Counters.keysAbove(weightCounts, threshold);
        s.append(keys.size()).append(" keys occur more than ").append(threshold).append(" times ");
        return s.toString();
    }

    public int totalSize() {
        return this.labelIndex.size() * this.featureIndex.size();
    }

    public String toHistogramString() {
        double[][] hist = new double[3][202];
        Object[][] histEg = new Object[3][202];
        int num = 0;
        int pos = 0;
        int neg = 0;
        int zero = 0;
        double total = 0.0;
        double x2total = 0.0;
        double max = 0.0;
        double min = 0.0;
        for (int f = 0; f < this.weights.length; ++f) {
            for (int l = 0; l < this.weights[f].length; ++l) {
                Pair<F, L> feat = new Pair<F, L>(this.featureIndex.get(f), this.labelIndex.get(l));
                ++num;
                double wt = this.weights[f][l];
                total += wt;
                x2total += wt * wt;
                if (wt > max) {
                    max = wt;
                }
                if (wt < min) {
                    min = wt;
                }
                if (wt < 0.0) {
                    ++neg;
                } else if (wt > 0.0) {
                    ++pos;
                } else {
                    ++zero;
                }
                int index = LinearClassifier.bucketizeValue(wt);
                double[] dArray = hist[0];
                int n = index;
                dArray[n] = dArray[n] + 1.0;
                if (histEg[0][index] == null) {
                    histEg[0][index] = feat;
                }
                if (!(wt < 0.1) || !(wt >= -0.1)) continue;
                index = LinearClassifier.bucketizeValue(wt * 100.0);
                double[] dArray2 = hist[1];
                int n2 = index;
                dArray2[n2] = dArray2[n2] + 1.0;
                if (histEg[1][index] == null) {
                    histEg[1][index] = feat;
                }
                if (!(wt < 0.001) || !(wt >= -0.001)) continue;
                index = LinearClassifier.bucketizeValue(wt * 10000.0);
                double[] dArray3 = hist[2];
                int n3 = index;
                dArray3[n3] = dArray3[n3] + 1.0;
                if (histEg[2][index] != null) continue;
                histEg[2][index] = feat;
            }
        }
        double ave = total / (double)num;
        double stddev = x2total / (double)num - ave * ave;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Linear classifier with " + num + " f(x,y) features");
        pw.println("Average weight: " + ave + "; std dev: " + stddev);
        pw.println("Max weight: " + max + " min weight: " + min);
        pw.println("Weights: " + neg + " negative; " + pos + " positive; " + zero + " zero.");
        LinearClassifier.printHistCounts(0, "Counts of lambda parameters between [-10, 10)", pw, hist, histEg);
        LinearClassifier.printHistCounts(1, "Closeup view of [-0.1, 0.1) depicted * 10^2", pw, hist, histEg);
        LinearClassifier.printHistCounts(2, "Closeup view of [-0.001, 0.001) depicted * 10^4", pw, hist, histEg);
        pw.close();
        return sw.toString();
    }

    public String toString() {
        return this.toString("WeightHistogram", 0);
    }

    public String toString(String style, int param) {
        if (style == null || "".equals(style)) {
            return "LinearClassifier with " + this.featureIndex.size() + " features, " + this.labelIndex.size() + " classes, and " + this.labelIndex.size() * this.featureIndex.size() + " parameters.\n";
        }
        if (style.equalsIgnoreCase("HighWeight")) {
            return this.toBiggestWeightFeaturesString(false, param, true);
        }
        if (style.equalsIgnoreCase("HighMagnitude")) {
            return this.toBiggestWeightFeaturesString(true, param, true);
        }
        if (style.equalsIgnoreCase("AllWeights")) {
            return this.toAllWeightsString();
        }
        if (style.equalsIgnoreCase("WeightHistogram")) {
            return this.toHistogramString();
        }
        if (style.equalsIgnoreCase("WeightDistribution")) {
            return this.toDistributionString(param);
        }
        throw new IllegalArgumentException("Unknown style: " + style);
    }

    private static int bucketizeValue(double wt) {
        int index = wt >= 0.0 ? (int)(wt * 10.0) + 100 : (int)Math.floor(wt * 10.0) + 100;
        if (index < 0) {
            index = 201;
        } else if (index > 200) {
            index = 200;
        }
        return index;
    }

    private static void printHistCounts(int ind, String title, PrintWriter pw, double[][] hist, Object[][] histEg) {
        pw.println(title);
        for (int i = 0; i < 200; ++i) {
            int fracpart;
            int intpart;
            if (i < 100) {
                intpart = 10 - (i + 9) / 10;
                fracpart = (10 - i % 10) % 10;
            } else {
                intpart = i / 10 - 10;
                fracpart = i % 10;
            }
            pw.print("[" + (i < 100 ? "-" : "") + intpart + "." + fracpart + ", " + (i < 100 ? "-" : "") + intpart + "." + fracpart + "+0.1): " + hist[ind][i]);
            if (histEg[ind][i] != null) {
                pw.print("  [" + histEg[ind][i] + (hist[ind][i] > 1.0 ? ", ..." : "") + "]");
            }
            pw.println();
        }
    }

    public String toAllWeightsString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Linear classifier with the following weights");
        BasicDatum<Object, F> allFeatures = new BasicDatum<Object, F>(this.features(), (Object)null);
        this.justificationOf(allFeatures, pw);
        return sw.toString();
    }

    public void dump() {
        BasicDatum<Object, F> allFeatures = new BasicDatum<Object, F>(this.features(), (Object)null);
        this.justificationOf(allFeatures);
    }

    public void dump(PrintWriter pw) {
        BasicDatum<Object, F> allFeatures = new BasicDatum<Object, F>(this.features(), (Object)null);
        this.justificationOf(allFeatures, pw);
    }

    @Deprecated
    public void justificationOf(RVFDatum<L, F> example) {
        PrintWriter pw = new PrintWriter(System.err, true);
        this.justificationOf(example, pw);
    }

    private void justificationOfRVFDatum(RVFDatum<L, F> example, PrintWriter pw) {
        int featureLength = 0;
        int labelLength = 6;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
        if (nf instanceof DecimalFormat) {
            ((DecimalFormat)nf).setPositivePrefix(" ");
        }
        Counter<F> features = example.asFeaturesCounter();
        for (F f : features.keySet()) {
            featureLength = Math.max(featureLength, f.toString().length() + 2 + nf.format(features.getCount(f)).length());
        }
        featureLength = Math.max(featureLength, "Total:".length());
        featureLength = Math.min(featureLength, 50);
        for (Object l : this.labels()) {
            labelLength = Math.max(labelLength, l.toString().length());
        }
        StringBuilder header = new StringBuilder("");
        for (int s = 0; s < featureLength; ++s) {
            header.append(' ');
        }
        for (L l : this.labels()) {
            header.append(' ');
            header.append(StringUtils.pad(l, labelLength));
        }
        pw.println(header);
        for (Object f : features.keySet()) {
            String fStr = f.toString();
            StringBuilder line = new StringBuilder(fStr);
            line.append("[").append(nf.format(features.getCount(f))).append("]");
            fStr = line.toString();
            for (int s = fStr.length(); s < featureLength; ++s) {
                line.append(' ');
            }
            for (L l : this.labels()) {
                String lStr = nf.format(this.weight(f, l));
                line.append(' ');
                line.append(lStr);
                for (int s = lStr.length(); s < labelLength; ++s) {
                    line.append(' ');
                }
            }
            pw.println(line);
        }
        Counter<L> scores = this.scoresOfRVFDatum(example);
        StringBuilder footer = new StringBuilder("Total:");
        for (int s = footer.length(); s < featureLength; ++s) {
            footer.append(' ');
        }
        for (L l : this.labels()) {
            footer.append(' ');
            String str = nf.format(scores.getCount(l));
            footer.append(str);
            for (int s = str.length(); s < labelLength; ++s) {
                footer.append(' ');
            }
        }
        pw.println(footer);
        Distribution<L> distr = Distribution.distributionFromLogisticCounter(scores);
        footer = new StringBuilder("Prob:");
        for (int s = footer.length(); s < featureLength; ++s) {
            footer.append(' ');
        }
        for (L l : this.labels()) {
            footer.append(' ');
            String str = nf.format(distr.getCount(l));
            footer.append(str);
            for (int s = str.length(); s < labelLength; ++s) {
                footer.append(' ');
            }
        }
        pw.println(footer);
    }

    @Deprecated
    public void justificationOf(RVFDatum<L, F> example, PrintWriter pw) {
        int featureLength = 0;
        int labelLength = 6;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
        if (nf instanceof DecimalFormat) {
            ((DecimalFormat)nf).setPositivePrefix(" ");
        }
        Counter<F> features = example.asFeaturesCounter();
        for (F f : features.keySet()) {
            featureLength = Math.max(featureLength, f.toString().length() + 2 + nf.format(features.getCount(f)).length());
        }
        featureLength = Math.max(featureLength, "Total:".length());
        featureLength = Math.min(featureLength, 50);
        for (Object l : this.labels()) {
            labelLength = Math.max(labelLength, l.toString().length());
        }
        StringBuilder header = new StringBuilder("");
        for (int s = 0; s < featureLength; ++s) {
            header.append(' ');
        }
        for (L l : this.labels()) {
            header.append(' ');
            header.append(StringUtils.pad(l, labelLength));
        }
        pw.println(header);
        for (Object f : features.keySet()) {
            String fStr = f.toString();
            StringBuilder line = new StringBuilder(fStr);
            line.append("[").append(nf.format(features.getCount(f))).append("]");
            fStr = line.toString();
            for (int s = fStr.length(); s < featureLength; ++s) {
                line.append(' ');
            }
            for (L l : this.labels()) {
                String lStr = nf.format(this.weight(f, l));
                line.append(' ');
                line.append(lStr);
                for (int s = lStr.length(); s < labelLength; ++s) {
                    line.append(' ');
                }
            }
            pw.println(line);
        }
        Counter<L> scores = this.scoresOf(example);
        StringBuilder footer = new StringBuilder("Total:");
        for (int s = footer.length(); s < featureLength; ++s) {
            footer.append(' ');
        }
        for (L l : this.labels()) {
            footer.append(' ');
            String str = nf.format(scores.getCount(l));
            footer.append(str);
            for (int s = str.length(); s < labelLength; ++s) {
                footer.append(' ');
            }
        }
        pw.println(footer);
        Distribution<L> distr = Distribution.distributionFromLogisticCounter(scores);
        footer = new StringBuilder("Prob:");
        for (int s = footer.length(); s < featureLength; ++s) {
            footer.append(' ');
        }
        for (L l : this.labels()) {
            footer.append(' ');
            String str = nf.format(distr.getCount(l));
            footer.append(str);
            for (int s = str.length(); s < labelLength; ++s) {
                footer.append(' ');
            }
        }
        pw.println(footer);
    }

    public void justificationOf(Datum<L, F> example) {
        PrintWriter pw = new PrintWriter(System.err, true);
        this.justificationOf(example, pw);
    }

    public <T> void justificationOf(Datum<L, F> example, PrintWriter pw, Function<F, T> printer) {
        this.justificationOf(example, pw, printer, false);
    }

    public <T> void justificationOf(Datum<L, F> example, PrintWriter pw, Function<F, T> printer, boolean sortedByFeature) {
        if (example instanceof RVFDatum) {
            this.justificationOfRVFDatum((RVFDatum)example, pw);
            return;
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
        if (nf instanceof DecimalFormat) {
            ((DecimalFormat)nf).setPositivePrefix(" ");
        }
        int featureLength = 0;
        for (Object f : example.asFeatures()) {
            int length = f.toString().length();
            if (printer != null) {
                length = printer.apply(f).toString().length();
            }
            featureLength = Math.max(featureLength, length);
        }
        featureLength = Math.max(featureLength, "Total:".length());
        featureLength = Math.min(featureLength, 50);
        int labelLength = 6;
        for (L l : this.labels()) {
            labelLength = Math.max(labelLength, l.toString().length());
        }
        StringBuilder header = new StringBuilder("");
        for (int s = 0; s < featureLength; ++s) {
            header.append(' ');
        }
        for (L l : this.labels()) {
            header.append(' ');
            header.append(StringUtils.pad(l, labelLength));
        }
        pw.println(header);
        Collection featColl = example.asFeatures();
        if (sortedByFeature) {
            featColl = ErasureUtils.sortedIfPossible(featColl);
        }
        for (Object f : featColl) {
            String fStr = printer != null ? printer.apply(f).toString() : f.toString();
            StringBuilder line = new StringBuilder(fStr);
            for (int s = fStr.length(); s < featureLength; ++s) {
                line.append(' ');
            }
            for (L l : this.labels()) {
                String lStr = nf.format(this.weight(f, l));
                line.append(' ');
                line.append(lStr);
                for (int s = lStr.length(); s < labelLength; ++s) {
                    line.append(' ');
                }
            }
            pw.println(line);
        }
        Counter<L> scores = this.scoresOf(example);
        StringBuilder footer = new StringBuilder("Total:");
        for (int s = footer.length(); s < featureLength; ++s) {
            footer.append(' ');
        }
        for (L l : this.labels()) {
            footer.append(' ');
            String str = nf.format(scores.getCount(l));
            footer.append(str);
            for (int s = str.length(); s < labelLength; ++s) {
                footer.append(' ');
            }
        }
        pw.println(footer);
        Distribution<L> distr = Distribution.distributionFromLogisticCounter(scores);
        footer = new StringBuilder("Prob:");
        for (int s = footer.length(); s < featureLength; ++s) {
            footer.append(' ');
        }
        for (L l : this.labels()) {
            footer.append(' ');
            String str = nf.format(distr.getCount(l));
            footer.append(str);
            for (int s = str.length(); s < labelLength; ++s) {
                footer.append(' ');
            }
        }
        pw.println(footer);
    }

    public Map<L, Counter<F>> weightsAsMapOfCounters() {
        Map mapOfCounters = Generics.newHashMap();
        for (Object label : this.labelIndex) {
            int labelID = this.labelIndex.indexOf(label);
            ClassicCounter c = new ClassicCounter();
            mapOfCounters.put(label, c);
            for (Object f : this.featureIndex) {
                c.incrementCount(f, this.weights[this.featureIndex.indexOf(f)][labelID]);
            }
        }
        return mapOfCounters;
    }

    public void justificationOf(Datum<L, F> example, PrintWriter pw) {
        this.justificationOf(example, pw, null);
    }

    public void dumpSorted() {
        BasicDatum<Object, F> allFeatures = new BasicDatum<Object, F>(this.features(), (Object)null);
        this.justificationOf(allFeatures, new PrintWriter(System.err, true), true);
    }

    public void justificationOf(Datum<L, F> example, PrintWriter pw, boolean sorted) {
        if (example instanceof RVFDatum) {
            this.justificationOf(example, pw, null, sorted);
        }
    }

    public Counter<L> scoresOf(Datum<L, F> example, Collection<L> possibleLabels) {
        ClassicCounter<L> scores = new ClassicCounter<L>();
        for (L l : possibleLabels) {
            if (this.labelIndex.indexOf(l) == -1) continue;
            double score = this.scoreOf(example, l);
            scores.setCount(l, score);
        }
        return scores;
    }

    public L experimentalClassOf(Datum<L, F> example) {
        if (example instanceof RVFDatum) {
            throw new UnsupportedOperationException();
        }
        int labelCount = this.weights[0].length;
        Collection features = example.asFeatures();
        int[] featureInts = new int[features.size()];
        int fI = 0;
        for (Object feature : features) {
            featureInts[fI++] = this.featureIndex.indexOf(feature);
        }
        double bestScore = Double.NEGATIVE_INFINITY;
        int bestI = 0;
        for (int i = 0; i < labelCount; ++i) {
            double score = 0.0;
            for (int j = 0; j < featureInts.length; ++j) {
                if (featureInts[j] < 0) continue;
                score += this.weights[featureInts[j]][i];
            }
            if (!(score > bestScore)) continue;
            bestI = i;
            bestScore = score;
        }
        return this.labelIndex.get(bestI);
    }

    @Override
    public L classOf(Datum<L, F> example) {
        if (example instanceof RVFDatum) {
            return this.classOfRVFDatum((RVFDatum)example);
        }
        Counter<L> scores = this.scoresOf(example);
        return Counters.argmax(scores);
    }

    private L classOfRVFDatum(RVFDatum<L, F> example) {
        Counter<L> scores = this.scoresOfRVFDatum(example);
        return Counters.argmax(scores);
    }

    @Override
    @Deprecated
    public L classOf(RVFDatum<L, F> example) {
        Counter<L> scores = this.scoresOf(example);
        return Counters.argmax(scores);
    }

    public LinearClassifier(double[][] weights, Index<F> featureIndex, Index<L> labelIndex) {
        this.featureIndex = featureIndex;
        this.labelIndex = labelIndex;
        this.weights = weights;
        this.thresholds = new double[labelIndex.size()];
        Arrays.fill(this.thresholds, 0.0);
    }

    public LinearClassifier(double[][] weights, Index<F> featureIndex, Index<L> labelIndex, double[] thresholds) throws Exception {
        this.featureIndex = featureIndex;
        this.labelIndex = labelIndex;
        this.weights = weights;
        if (thresholds.length != labelIndex.size()) {
            throw new Exception("Number of thresholds and number of labels do not match.");
        }
        thresholds = new double[thresholds.length];
        int curr = 0;
        for (double tval : thresholds) {
            thresholds[curr++] = tval;
        }
        Arrays.fill(thresholds, 0.0);
    }

    public LinearClassifier(double[] weights, Index<Pair<F, L>> weightIndex) {
        ClassicCounter<Pair<F, L>> weightCounter = new ClassicCounter<Pair<F, L>>();
        for (int i = 0; i < weightIndex.size(); ++i) {
            if (weights[i] == 0.0) continue;
            weightCounter.setCount(weightIndex.get(i), weights[i]);
        }
        this.init(weightCounter, new ClassicCounter());
    }

    public LinearClassifier(Counter<? extends Pair<F, L>> weightCounter) {
        this(weightCounter, new ClassicCounter());
    }

    public LinearClassifier(Counter<? extends Pair<F, L>> weightCounter, Counter<L> thresholdsC) {
        this.init(weightCounter, thresholdsC);
    }

    /*
     * WARNING - void declaration
     */
    private void init(Counter<? extends Pair<F, L>> weightCounter, Counter<L> thresholdsC) {
        void var5_9;
        Set<Pair<F, L>> keys = weightCounter.keySet();
        this.featureIndex = new HashIndex<F>();
        this.labelIndex = new HashIndex<L>();
        for (Pair pair : keys) {
            this.featureIndex.add(pair.first());
            this.labelIndex.add(pair.second());
        }
        this.thresholds = new double[this.labelIndex.size()];
        for (Object object : this.labelIndex) {
            this.thresholds[this.labelIndex.indexOf(object)] = thresholdsC.getCount(object);
        }
        this.weights = new double[this.featureIndex.size()][this.labelIndex.size()];
        Pair tempPair = new Pair();
        boolean bl = false;
        while (var5_9 < this.weights.length) {
            for (int l = 0; l < this.weights[var5_9].length; ++l) {
                tempPair.first = this.featureIndex.get((int)var5_9);
                tempPair.second = this.labelIndex.get(l);
                this.weights[var5_9][l] = weightCounter.getCount(tempPair);
            }
            ++var5_9;
        }
    }

    public void adaptWeights(Dataset<L, F> adapt, LinearClassifierFactory<L, F> lcf) {
        System.err.println("before adapting, weights size=" + this.weights.length);
        this.weights = lcf.adaptWeights(this.weights, adapt);
        System.err.println("after adapting, weights size=" + this.weights.length);
    }

    public double[][] weights() {
        return this.weights;
    }

    public void setWeights(double[][] newWeights) {
        this.weights = newWeights;
    }

    public static <L, F> LinearClassifier<L, F> readClassifier(String loadPath) {
        System.err.print("Deserializing classifier from " + loadPath + "...");
        try {
            ObjectInputStream ois = IOUtils.readStreamFromString(loadPath);
            LinearClassifier classifier = (LinearClassifier)ErasureUtils.uncheckedCast(ois.readObject());
            ois.close();
            return classifier;
        }
        catch (Exception e) {
            throw new RuntimeException("Deserialization failed: " + e.getMessage(), e);
        }
    }

    public static void writeClassifier(LinearClassifier<?, ?> classifier, String writePath) {
        try {
            IOUtils.writeObjectToFile(classifier, writePath);
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed: " + e.getMessage(), e);
        }
    }

    public void saveToFilename(String file) {
        try {
            File tgtFile = new File(file);
            BufferedWriter out2 = new BufferedWriter(new FileWriter(tgtFile));
            this.labelIndex.saveToWriter(out2);
            this.featureIndex.saveToWriter(out2);
            int numLabels = this.labelIndex.size();
            int numFeatures = this.featureIndex.size();
            for (int featIndex = 0; featIndex < numFeatures; ++featIndex) {
                for (int labelIndex = 0; labelIndex < numLabels; ++labelIndex) {
                    out2.write(String.valueOf(featIndex));
                    out2.write(TEXT_SERIALIZATION_DELIMITER);
                    out2.write(String.valueOf(labelIndex));
                    out2.write(TEXT_SERIALIZATION_DELIMITER);
                    out2.write(String.valueOf(this.weight(featIndex, labelIndex)));
                    out2.write("\n");
                }
            }
            out2.write("\n");
            out2.write(String.valueOf(this.thresholds.length));
            out2.write("\n");
            for (double val : this.thresholds) {
                out2.write(String.valueOf(val));
                out2.write("\n");
            }
            out2.close();
        }
        catch (Exception e) {
            System.err.println("Error attempting to save classifier to file=" + file);
            e.printStackTrace();
        }
    }
}

