/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.test.seg;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.dictionary.DictionaryMaker;
import com.hankcs.hanlp.dictionary.BiGramDictionary;
import com.hankcs.hanlp.dictionary.CoreBiGramTableDictionary;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import junit.framework.TestCase;

public class testBiGramDictionary
extends TestCase {
    public void testBiGramDictionary() {
        testBiGramDictionary.assertEquals((int)15, (int)BiGramDictionary.getBiFrequency("\u56e2\u7ed3", "\u594b\u6597"));
        testBiGramDictionary.assertEquals((int)1, (int)BiGramDictionary.getBiFrequency("\u56e2\u7ed3", "\u62fc\u640f"));
        HanLP.Config.enableDebug();
        BiGramDictionary.getBiFrequency("\u56e2\u7ed3@\u594b\u6597");
    }

    public void testTable() throws Exception {
        testBiGramDictionary.assertEquals((int)106, (int)CoreBiGramTableDictionary.getBiFrequency("\u5ef6\u7eed", "\u672a##\u65f6"));
    }

    public void testFastBiGram() throws Exception {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(HanLP.Config.BiGramDictionaryPath)));
        DictionaryMaker dictionaryMaker = new DictionaryMaker();
        double total = 0.0;
        double right = 0.0;
        while ((line = br.readLine()) != null) {
            total += 1.0;
            String[] params = line.split("\\s");
            String[] twoWord = params[0].split("@", 2);
            String a = twoWord[0];
            String b = twoWord[1];
            int idA = CoreBiGramTableDictionary.getWordID(a);
            int idB = CoreBiGramTableDictionary.getWordID(b);
            if (BiGramDictionary.getBiFrequency(a, b) != CoreBiGramTableDictionary.getBiFrequency(idA, idB)) {
                System.out.println(line);
                if (idA < 0) {
                    dictionaryMaker.add(a, "n");
                }
                if (idB >= 0) continue;
                dictionaryMaker.add(b, "n");
                continue;
            }
            right += 1.0;
        }
        br.close();
        System.out.println("\u8986\u76d6\u7387\uff1a" + right / total);
        dictionaryMaker.saveTxtTo("data/test/out.txt");
    }

    public void testSingle() throws Exception {
        HanLP.Config.enableDebug();
        System.out.println(CoreBiGramTableDictionary.getBiFrequency("\u56e2\u7ed3", "\u594b\u6597"));
    }

    public void testBenchmark() throws Exception {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(HanLP.Config.BiGramDictionaryPath)));
        LinkedList<String[]> twoWordList = new LinkedList<String[]>();
        while ((line = br.readLine()) != null) {
            String[] params = line.split("\\s");
            String[] twoWord = params[0].split("@", 2);
            twoWordList.add(twoWord);
        }
        br.close();
        long start = System.currentTimeMillis();
        for (String[] stringArray : twoWordList) {
        }
    }

    public void testObjectOutPut() throws Exception {
        int size = 5563418;
        int[] array = new int[size];
        int i = 0;
        while (i < array.length) {
            array[i] = i;
            ++i;
        }
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("data/test/out.bin"));
        out.writeObject(array);
        out.close();
        long start = System.currentTimeMillis();
        ObjectInputStream in = new ObjectInputStream(new FileInputStream("data/test/out.bin"));
        int[] inArray = (int[])in.readObject();
        System.out.println(System.currentTimeMillis() - start);
        int i2 = 0;
        while (i2 < inArray.length) {
            testBiGramDictionary.assertEquals((int)i2, (int)inArray[i2]);
            ++i2;
        }
    }
}

