/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.test.corpus;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ByteArrayStream;
import com.hankcs.hanlp.model.maxent.MaxEntModel;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import junit.framework.TestCase;

public class TestBytesArray
extends TestCase {
    public static final String DATA_OUT_DAT = "data/test/out.dat";

    public void testWriteAndRead() throws Exception {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(DATA_OUT_DAT));
        out.writeChar(72);
        out.writeChar(101);
        out.writeChar(108);
        out.writeChar(108);
        out.writeChar(111);
        out.close();
        ByteArray byteArray = ByteArray.createByteArray(DATA_OUT_DAT);
        while (byteArray.hasMore()) {
            System.out.println(byteArray.nextChar());
        }
    }

    public void testWriteBigFile() throws Exception {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(DATA_OUT_DAT));
        int i = 0;
        while (i < 10000) {
            out.writeInt(i);
            ++i;
        }
        out.close();
    }

    public void testStream() throws Exception {
        ByteArrayStream byteArray = ByteArrayStream.createByteArrayStream(DATA_OUT_DAT);
        while (((ByteArray)byteArray).hasMore()) {
            System.out.println(((ByteArray)byteArray).nextInt());
        }
    }

    public void testLoadByteArray() throws Exception {
        ByteArray byteArray = ByteArray.createByteArray(String.valueOf(HanLP.Config.MaxEntModelPath) + ".bin");
        MaxEntModel.create(byteArray);
    }

    public void testLoadByteArrayStream() throws Exception {
        ByteArrayStream byteArray = ByteArrayStream.createByteArrayStream(String.valueOf(HanLP.Config.MaxEntModelPath) + ".bin");
        MaxEntModel.create(byteArray);
    }

    public void testBenchmark() throws Exception {
        ByteArray byteArray = ByteArray.createByteArray(String.valueOf(HanLP.Config.MaxEntModelPath) + ".bin");
        MaxEntModel.create(byteArray);
        byteArray = ByteArrayStream.createByteArrayStream(String.valueOf(HanLP.Config.MaxEntModelPath) + ".bin");
        MaxEntModel.create(byteArray);
        long start = System.currentTimeMillis();
        byteArray = ByteArray.createByteArray(String.valueOf(HanLP.Config.MaxEntModelPath) + ".bin");
        MaxEntModel.create(byteArray);
        System.out.printf("ByteArray: %d ms\n", System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        byteArray = ByteArrayStream.createByteArrayStream(String.valueOf(HanLP.Config.MaxEntModelPath) + ".bin");
        MaxEntModel.create(byteArray);
        System.out.printf("ByteArrayStream: %d ms\n", System.currentTimeMillis() - start);
    }
}

