/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.test.algorithm;

import com.hankcs.hanlp.collection.MDAG.MDAGMap;
import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.corpus.io.IOUtil;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.TestCase;

public class MDAGMapTest
extends TestCase {
    MDAGMap<Integer> mdagMap = new MDAGMap();
    Set<String> validKeySet;

    public void setUp() throws Exception {
        IOUtil.LineIterator iterator = new IOUtil.LineIterator("data/dictionary/custom/CustomDictionary.txt");
        this.validKeySet = new TreeSet<String>();
        while (iterator.hasNext()) {
            this.validKeySet.add(iterator.next().split("\\s")[0]);
        }
    }

    public void testPut() throws Exception {
        for (String word : this.validKeySet) {
            this.mdagMap.put(word, (Integer)word.length());
        }
    }

    public void testGet() throws Exception {
        this.testPut();
        this.mdagMap.simplify();
        for (String word : this.validKeySet) {
            MDAGMapTest.assertEquals((int)word.length(), (int)this.mdagMap.get(word));
        }
    }

    public void testSingle() throws Exception {
        this.testPut();
        this.mdagMap.simplify();
        System.out.println(this.mdagMap.get("\u9f7f\u8f6e\u5382"));
    }

    public void testCommonPrefixSearch() throws Exception {
        this.testPut();
        System.out.println(this.mdagMap.commonPrefixSearchWithValue("\u4e00\u4e3e\u4e00\u52a8"));
    }

    public void testBenchmark() throws Exception {
        this.testPut();
        BinTrie<Integer> binTrie = new BinTrie<Integer>();
        for (String key : this.validKeySet) {
            binTrie.put(key, Integer.valueOf(key.length()));
        }
        this.mdagMap.simplify();
        for (String key : this.validKeySet) {
            MDAGMapTest.assertEquals((int)binTrie.commonPrefixSearchWithValue(key).size(), (int)this.mdagMap.commonPrefixSearchWithValue(key).size());
        }
        long start = System.currentTimeMillis();
        for (String key : this.validKeySet) {
            binTrie.commonPrefixSearchWithValue(key);
        }
        System.out.printf("binTrie: %d ms\n", System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        for (String key : this.validKeySet) {
            this.mdagMap.commonPrefixSearchWithValue(key);
        }
        System.out.printf("mdagMap: %d ms\n", System.currentTimeMillis() - start);
    }
}

