/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary;

import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;

public class TransformMatrixDictionary<E extends Enum<E>> {
    Class<E> enumType;
    public int ordinaryMax;
    int[][] matrix;
    int[] total;
    int totalFrequency;
    public int[] states;
    public double[] start_probability;
    public double[][] transititon_probability;

    public TransformMatrixDictionary(Class<E> enumType) {
        this.enumType = enumType;
    }

    public boolean load(String path) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            String line = br.readLine();
            String[] _param = line.split(",");
            String[] labels = new String[_param.length - 1];
            System.arraycopy(_param, 1, labels, 0, labels.length);
            int[] ordinaryArray = new int[labels.length];
            this.ordinaryMax = 0;
            int i = 0;
            while (i < ordinaryArray.length) {
                ordinaryArray[i] = ((Enum)this.convert(labels[i])).ordinal();
                this.ordinaryMax = Math.max(this.ordinaryMax, ordinaryArray[i]);
                ++i;
            }
            ++this.ordinaryMax;
            this.matrix = new int[this.ordinaryMax][this.ordinaryMax];
            i = 0;
            while (i < this.ordinaryMax) {
                int j = 0;
                while (j < this.ordinaryMax) {
                    this.matrix[i][j] = 0;
                    ++j;
                }
                ++i;
            }
            while ((line = br.readLine()) != null) {
                String[] paramArray = line.split(",");
                int currentOrdinary = ((Enum)this.convert(paramArray[0])).ordinal();
                int i2 = 0;
                while (i2 < ordinaryArray.length) {
                    this.matrix[currentOrdinary][ordinaryArray[i2]] = Integer.valueOf(paramArray[1 + i2]);
                    ++i2;
                }
            }
            br.close();
            this.total = new int[this.ordinaryMax];
            int j = 0;
            while (j < this.ordinaryMax) {
                this.total[j] = 0;
                int i3 = 0;
                while (i3 < this.ordinaryMax) {
                    int n = j;
                    this.total[n] = this.total[n] + this.matrix[i3][j];
                    int n2 = j;
                    this.total[n2] = this.total[n2] + this.matrix[j][i3];
                    ++i3;
                }
                ++j;
            }
            j = 0;
            while (j < this.ordinaryMax) {
                int n = j;
                this.total[n] = this.total[n] - this.matrix[j][j];
                ++j;
            }
            j = 0;
            while (j < this.ordinaryMax) {
                this.totalFrequency += this.total[j];
                ++j;
            }
            this.states = ordinaryArray;
            this.start_probability = new double[this.ordinaryMax];
            int[] nArray = this.states;
            int n = this.states.length;
            int n3 = 0;
            while (n3 < n) {
                int s = nArray[n3];
                double frequency = (double)this.total[s] + 1.0E-8;
                this.start_probability[s] = -Math.log(frequency / (double)this.totalFrequency);
                ++n3;
            }
            this.transititon_probability = new double[this.ordinaryMax][this.ordinaryMax];
            nArray = this.states;
            n = this.states.length;
            n3 = 0;
            while (n3 < n) {
                int from = nArray[n3];
                int[] nArray2 = this.states;
                int n4 = this.states.length;
                int n5 = 0;
                while (n5 < n4) {
                    int to = nArray2[n5];
                    double frequency = (double)this.matrix[from][to] + 1.0E-8;
                    this.transititon_probability[from][to] = -Math.log(frequency / (double)this.total[from]);
                    ++n5;
                }
                ++n3;
            }
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6" + path + "\u5931\u8d25" + e);
        }
        return true;
    }

    public int getFrequency(String from, String to) {
        return this.getFrequency(this.convert(from), this.convert(to));
    }

    public int getFrequency(E from, E to) {
        return this.matrix[((Enum)from).ordinal()][((Enum)to).ordinal()];
    }

    public int getTotalFrequency(E e) {
        return this.total[((Enum)e).ordinal()];
    }

    public int getTotalFrequency() {
        return this.totalFrequency;
    }

    protected E convert(String label) {
        return Enum.valueOf(this.enumType, label);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransformMatrixDictionary{");
        sb.append("enumType=").append(this.enumType);
        sb.append(", ordinaryMax=").append(this.ordinaryMax);
        sb.append(", matrix=").append(Arrays.toString((Object[])this.matrix));
        sb.append(", total=").append(Arrays.toString(this.total));
        sb.append(", totalFrequency=").append(this.totalFrequency);
        sb.append('}');
        return sb.toString();
    }
}

