/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dictionary;

import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class SuffixDictionary {
    BinTrie<Integer> trie = new BinTrie();

    public void add(String word) {
        word = SuffixDictionary.reverse(word);
        this.trie.put(word, (Integer)word.length());
    }

    public void addAll(String total) {
        int i = 0;
        while (i < total.length()) {
            this.add(String.valueOf(total.charAt(i)));
            ++i;
        }
    }

    public void addAll(String[] total) {
        String[] stringArray = total;
        int n = total.length;
        int n2 = 0;
        while (n2 < n) {
            String single = stringArray[n2];
            this.add(single);
            ++n2;
        }
    }

    public int get(String suffix) {
        Integer length = this.trie.get(suffix = SuffixDictionary.reverse(suffix));
        if (length == null) {
            return 0;
        }
        return length;
    }

    public boolean endsWith(String word) {
        return this.trie.commonPrefixSearchWithValue(word = SuffixDictionary.reverse(word)).size() > 0;
    }

    public int getLongestSuffixLength(String word) {
        LinkedList<Map.Entry<String, Integer>> suffixList = this.trie.commonPrefixSearchWithValue(word = SuffixDictionary.reverse(word));
        if (suffixList.size() == 0) {
            return 0;
        }
        return suffixList.getLast().getValue();
    }

    private static String reverse(String word) {
        return new StringBuilder(word).reverse().toString();
    }

    public Set<Map.Entry<String, Integer>> entrySet() {
        LinkedHashSet<Map.Entry<String, Integer>> treeSet = new LinkedHashSet<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> entry : this.trie.entrySet()) {
            treeSet.add(new AbstractMap.SimpleEntry<String, Integer>(SuffixDictionary.reverse(entry.getKey()), entry.getValue()));
        }
        return treeSet;
    }
}

