/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.dartsclone.details;

class AutoBytePool {
    private byte[] _buf;
    private int _size;
    private int _capacity;

    AutoBytePool() {
    }

    byte[] getBuffer() {
        return this._buf;
    }

    byte get(int id) {
        return this._buf[id];
    }

    void set(int id, byte value) {
        this._buf[id] = value;
    }

    boolean empty() {
        return this._size == 0;
    }

    int size() {
        return this._size;
    }

    void clear() {
        this.resize(0);
        this._buf = null;
        this._size = 0;
        this._capacity = 0;
    }

    void add(byte value) {
        if (this._size == this._capacity) {
            this.resizeBuf(this._size + 1);
        }
        this._buf[this._size++] = value;
    }

    void deleteLast() {
        --this._size;
    }

    void resize(int size) {
        if (size > this._capacity) {
            this.resizeBuf(size);
        }
        this._size = size;
    }

    void resize(int size, byte value) {
        if (size > this._capacity) {
            this.resizeBuf(size);
        }
        while (this._size < size) {
            this._buf[this._size++] = value;
        }
    }

    void reserve(int size) {
        if (size > this._capacity) {
            this.resizeBuf(size);
        }
    }

    private void resizeBuf(int size) {
        int capacity;
        if (size >= this._capacity * 2) {
            capacity = size;
        } else {
            capacity = 1;
            while (capacity < size) {
                capacity <<= 1;
            }
        }
        byte[] buf = new byte[capacity];
        if (this._size > 0) {
            System.arraycopy(this._buf, 0, buf, 0, this._size);
        }
        this._buf = buf;
        this._capacity = capacity;
    }
}

