package com.zzsn.excelexportservice.dto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
/**
 * @Author: lxj
 * @Date: 2025/9/19 17:13
 */
public class RequestParamHelper {
    private static final Logger log = LoggerFactory.getLogger(RequestParamHelper.class);
    /**
     * 安全获取 Map 参数，带默认值
     *
     * @param params     请求参数 Map
     * @param key        参数 key
     * @param <T>        返回类型
     * @return 参数值或默认值
     */
    @SuppressWarnings("unchecked")
    public static <T> T getParam(Map<String, Object> params, String key) {
        if (params == null || !params.containsKey(key)) {
            return null;
        }
        Object val = params.get(key);
        if (val == null) {
            return null;
        }
        try {
            return (T) val;
        } catch (ClassCastException e) {
            log.warn("参数 {} 类型不正确，期望 {}, 实际 {}", key, val.getClass().getName(), e.getMessage());
            return null;
        }
    }

    public static List<String> getListParam(Map<String, Object> params, String key) {
        if (params == null || !params.containsKey(key)) {
            return Collections.emptyList();
        }
        Object val = params.get(key);

        // 如果已经是List类型，直接返回
        if (val instanceof List) {
            return (List<String>) val;
        }

        // 如果是字符串，尝试按逗号分割成列表
        if (val instanceof String) {
            String str = (String) val;
            if (str.trim().isEmpty()) {
                return Collections.emptyList();
            }
            return Arrays.asList(str.split(","));
        }

        // 其他情况返回空列表
        return Collections.emptyList();
    }

    public static Integer getIntegerParam(Map<String, Object> params, String key) {
        if (params == null || !params.containsKey(key)) {
            return null;
        }
        Object val = params.get(key);

        // 如果已经是List类型，直接返回
        if (val instanceof Integer) {
            return (Integer) val;
        }

        // 如果是字符串，尝试按逗号分割成列表
        if (val instanceof String) {
            String str = (String) val;
            if (str.trim().isEmpty()) {
                return Integer.valueOf(str);
            }
            return Integer.valueOf(str);
        }

        // 其他情况返回空列表
        return null;
    }

    public static String getStringParam(Map<String, Object> params, String key) {
        if (params == null || !params.containsKey(key)) {
            return null;
        }
        Object val = params.get(key);

        if (val == null) {
            return null;
        }

        // 如果已经是 String 类型，直接返回
        if (val instanceof String) {
            String str = (String) val;
            return str.trim().isEmpty() ? null : str.trim();
        }

        // 其他类型转换为 String
        return val.toString().trim();
    }

}
