package com.zzsn.excelexportservice.feign;

import com.zzsn.excelexportservice.dto.AeiModuleVo;

import com.zzsn.excelexportservice.dto.ExportDataResponse;
import com.zzsn.excelexportservice.dto.WorldTopAnalysis;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author: lxj
 * @Date: 2025/9/26 14:14
 */
@FeignClient(name = "enterprise-service"
        , url = "${excel.export.services.enterprise-service.data-url}"
)
public interface EnterpriseFeign {

    @GetMapping("/company/enterprise/detail/indexQuery/export/excel")
    ExportDataResponse enterpriseIndexQueryExport(
            @RequestParam("socialCreditCode") String socialCreditCode,
            @RequestParam("indexType") Integer indexType,
            @RequestParam(value = "indexNames", required = false) String indexNames
    );

    @GetMapping("/company/enterpriseData/getOnListRecord/export/excel")
    ExportDataResponse<?> getOnListRecordExport(
            @RequestParam("socialCreditCodes") String socialCreditCodes,
            @RequestParam("yearList") String yearList,
            @RequestParam("lists") String lists,
            @RequestParam("type") String type
    );

    @GetMapping("/company/finance_new/indexCompare/export/excel")
    ExportDataResponse<?> indexCompareExport(
            @RequestParam("socialCreditCode") List<String> socialCreditCodes,
            @RequestParam("year") List<String> years,
            @RequestParam("quarter") Integer quarter,
            @RequestParam("indexCode") String indexCode
    );

    @PostMapping("/company/enterprise/rankList/getWorldTopAnalysis/export/excel")
    ExportDataResponse<?> getWorldTopAnalysis(
            @RequestBody WorldTopAnalysis worldTopAnalysis
    );
    @PostMapping("/company/finance_new/indexCompareByIndustry/export/excel")
    ExportDataResponse<?> indexCompareByIndustryExport(
            @RequestBody(required = false) WorldTopAnalysis worldTopAnalysis,
            @RequestParam(value = "socialCreditCode", required = false) List<String> socialCreditCodes,
            @RequestParam(value = "year", required = false) List<String> years,
            @RequestParam(value = "quarter", required = false) Integer quarter,
            @RequestParam(value = "industries", required = false) String industry,
            @RequestParam(value = "indexCode", required = false) String indexCode
    );

    @GetMapping("/company/finance_new/coreIndexCompareByIndustry/export/excel")
    ExportDataResponse<?> coreIndexCompareByIndustryExport(
            @RequestParam(value = "socialCreditCode", required = false) List<String> socialCreditCodes,
            @RequestParam("year") List<String> years,
            @RequestParam(value = "industries", required = false) String industry,
            @RequestParam("indexName") String indexName,
            @RequestParam("type") String type
    );

    @PostMapping("/company/enterprise/rankList/getEnterpriseBenchmarking/export/excel")
    ExportDataResponse getEnterpriseBenchmarkingExport(
            @RequestBody WorldTopAnalysis worldTopAnalysis,
            @RequestParam("ids") String ids,
            @RequestParam("years") String years,
            @RequestParam("industrys") String industrys,
            @RequestParam("indexCode") String indexCode
    );
    @PostMapping("/company/enterprise/rankList/getTransnationalCompany/export/excel")
    ExportDataResponse getTransnationalCompanyExport(
            @RequestBody WorldTopAnalysis worldTopAnalysis,
            @RequestParam("ids") String ids,
            @RequestParam("years") String years,
            @RequestParam("industrys") String industrys,
            @RequestParam("indexCode") String indexCode
    );

    @PostMapping("/company/aei/pageList/export/excel")
    ExportDataResponse getPageAndTotalExport(
            @RequestParam("pageSize") Integer pageSize,
            @RequestParam( "currentPage") Integer currentPage,
            @RequestBody AeiModuleVo aeiModuleVo
    );



    @GetMapping("/company/finance_new/coreIndexCompare/export/excel")
    ExportDataResponse<?> coreIndexCompareExport(
            @RequestParam("socialCreditCode") List<String> socialCreditCodes,
            @RequestParam("year") List<String> years,
            @RequestParam("quarter") Integer quarter,
            @RequestParam(value = "indexName") String indexName
    );
}
