package com.zzsn.excelexportservice.feign;


import com.alibaba.fastjson2.JSONObject;
import com.zzsn.excelexportservice.dto.ExportDataResponse;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author: lxj
 * @Date: 2025/9/18 10:45
 */
@FeignClient(name = "research-center-fourth-server"
//        , url = "${excel.export.services.research-center-fourth-server.data-url}"
)
public interface ResearchFeign {
    @PostMapping("/benchmark/analyse/getHotKeywordTendency/export/excel")
    ExportDataResponse getHotKeywordTendency(
            @RequestParam("tid") String tid,
            @RequestParam("kids") String kids,
            @RequestParam("coids") String coids,
            @RequestParam("countryNames") String countryNames,
            @RequestParam("industryNames") String industryNames,
            @RequestParam(value = "countryType") Integer countryType,
            @RequestParam("topKids") String topKids,
            @RequestParam("startDate") String startDate,
            @RequestParam("endDate") String endDate,
            @RequestParam("dateType") Integer dateType,
            @RequestParam("weeks") Integer weeks,
            @RequestParam("labels") String labels,
            @RequestParam(value = "articleNum") Integer articleNum,
            @RequestParam(value = "count") Integer count,
            @RequestParam(value = "queryType") String queryType,
            @RequestParam("flagCode") String flagCode,
            @RequestParam("rankings") String rankings,
            @RequestParam(value = "columnId") String columnId
    );

    @GetMapping("/special/universal/getKeyWordsSetById/export/excel")
    ExportDataResponse getKeyWordsSetById(
            @RequestParam("id") String id,
            @RequestParam("limitNumber") Integer limitNumber,
            @RequestParam("keyWordsNum") Integer keyWordsNum,
            @RequestParam("title") String title
    );

    @PostMapping("/benchmark/analyse/getHotKeywordList/export/excel")
    ExportDataResponse<?> getHotKeywordListExport(
            @RequestParam("tid") String tid,
            @RequestParam("kids") String kids,
            @RequestParam("coids") String coids,
            @RequestParam("countryNames") String countryNames,
            @RequestParam("industryNames") String industryNames,
            @RequestParam("labels") String labels,
            @RequestParam(value = "countryType", defaultValue = "0") Integer countryType,
            @RequestParam("startDate") String startDate,
            @RequestParam("endDate") String endDate,
            @RequestParam("dateType") Integer dateType,
            @RequestParam(value = "count", defaultValue = "20") Integer count,
            @RequestParam(value = "queryType", defaultValue = "0") String queryType,
            @RequestParam("flagCode") String flagCode,
            @RequestParam("rankings") String rankings,
            @RequestParam(value = "columnId", required = false) String columnId
    );


    @PostMapping("/interface/query/export/excel")
    ExportDataResponse queryExportExcel(
            @RequestBody JSONObject jsonObject);

}
