package com.zzsn.excelexportservice.factorys;

import com.zzsn.excelexportservice.exportStrategys.ExportStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: lxj
 * @Date: 2025/9/25 17:11
 */
@Component
public class ExportStrategyFactory {

    private final Map<String, ExportStrategy> strategyMap = new HashMap<>();

    @Autowired
    public ExportStrategyFactory(List<ExportStrategy> strategies) {
        for (ExportStrategy strategy : strategies) {
            String key;
            if (strategy.getApiPath() == null) {
                // 该 serviceName 下所有 apiPath 都由它处理
                key = strategy.getServiceName();
            } else {
                key = strategy.getServiceName() + "#" + strategy.getApiPath();
            }
            strategyMap.put(key, strategy);
        }
    }

    public ExportStrategy getStrategy(String serviceName, String apiPath) {
        // 优先查具体路径
        ExportStrategy strategy = strategyMap.get(serviceName + "#" + apiPath);
        if (strategy != null) {
            return strategy;
        }
        // 退化查 serviceName 级别（表示该 serviceName 全部交给某个策略）
        return strategyMap.get(serviceName);
    }
}
