package com.zzsn.excelexportservice.exportStrategys;

import com.alibaba.fastjson2.JSONObject;
import com.zzsn.excelexportservice.dto.ExportDataResponse;
import com.zzsn.excelexportservice.dto.ExportReq;
import com.zzsn.excelexportservice.dto.RequestParamHelper;
import com.zzsn.excelexportservice.feign.ResearchFeign;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author: lxj
 * @Date: 2025/9/25 16:50
 */
@Component
public class ResearchStrategy implements ExportStrategy {

    @Autowired
    private ResearchFeign zdqyFeign;

    private final Map<String, TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>>> pathMapping = new HashMap<>();

    @PostConstruct
    public void init() {
        // 热词趋势导出
        register("/research/benchmark/analyse/getHotKeywordTendency/export/excel",
                (request, queryParams, exportReq) -> zdqyFeign.getHotKeywordTendency(
                        RequestParamHelper.getStringParam(queryParams, "tid"),
                        RequestParamHelper.getStringParam(queryParams, "kids"),
                        RequestParamHelper.getStringParam(queryParams, "coids"),
                        RequestParamHelper.getStringParam(queryParams, "countryNames"),
                        RequestParamHelper.getStringParam(queryParams, "industryNames"),
                        RequestParamHelper.getIntegerParam(queryParams, "countryType"),
                        RequestParamHelper.getStringParam(queryParams, "topKids"),
                        RequestParamHelper.getStringParam(queryParams, "startDate"),
                        RequestParamHelper.getStringParam(queryParams, "endDate"),
                        RequestParamHelper.getIntegerParam(queryParams, "dateType"),
                        RequestParamHelper.getIntegerParam(queryParams, "weeks"),
                        RequestParamHelper.getStringParam(queryParams, "labels"),
                        RequestParamHelper.getIntegerParam(queryParams, "articleNum"),
                        RequestParamHelper.getIntegerParam(queryParams, "count"),
                        RequestParamHelper.getStringParam(queryParams, "queryType"),
                        RequestParamHelper.getStringParam(queryParams, "flagCode"),
                        RequestParamHelper.getStringParam(queryParams, "rankings"),
                        RequestParamHelper.getStringParam(queryParams, "columnId")
                ));

        // 特殊关键词集导出
        register("/research/special/universal/getKeyWordsSetById/export/excel",
                (request, queryParams, exportReq) -> zdqyFeign.getKeyWordsSetById(
                        RequestParamHelper.getStringParam(queryParams, "id"),
                        RequestParamHelper.getIntegerParam(queryParams, "limitNumber"),
                        RequestParamHelper.getIntegerParam(queryParams, "keyWordsNum"),
                        RequestParamHelper.getStringParam(queryParams, "title")
                ));

        // 热词列表导出
        register("/research/benchmark/analyse/getHotKeywordList/export/excel",
                (request, queryParams, exportReq) -> zdqyFeign.getHotKeywordListExport(
                        // String类型参数使用getStringParam避免类型转换错误
                        RequestParamHelper.getStringParam(queryParams, "tid"),
                        RequestParamHelper.getStringParam(queryParams, "kids"),
                        RequestParamHelper.getStringParam(queryParams, "coids"),
                        RequestParamHelper.getStringParam(queryParams, "countryNames"),
                        RequestParamHelper.getStringParam(queryParams, "industryNames"),
                        RequestParamHelper.getStringParam(queryParams, "labels"),
                        // Integer类型参数保持不变

                        RequestParamHelper.getIntegerParam(queryParams, "countryType"),
                        RequestParamHelper.getStringParam(queryParams, "startDate"),
                        RequestParamHelper.getStringParam(queryParams, "endDate"),
                        RequestParamHelper.getIntegerParam(queryParams, "dateType"),
                        RequestParamHelper.getIntegerParam(queryParams, "count"),
                        RequestParamHelper.getStringParam(queryParams, "queryType"),
                        RequestParamHelper.getStringParam(queryParams, "flagCode"),
                        RequestParamHelper.getStringParam(queryParams, "rankings"),
                        RequestParamHelper.getStringParam(queryParams, "columnId")
                ));

        // 通用接口导出
        register("/research/interface/query/export/excel",
                (request, queryParams, exportReq) -> zdqyFeign.queryExportExcel(new JSONObject(queryParams)));
    }

    private void register(String path,
                          TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>> func) {
        pathMapping.put(path, (request, queryParams, exportReq) -> {
            try {
                return func.apply(request, queryParams, exportReq);
            } catch (Exception e) {
                // Feign 调用异常或其他不可预期异常统一处理
                return new ExportDataResponse<>(2, "调用 Research 接口失败：" + e.getMessage(),
                        Collections.emptyList(), Collections.emptyList());
            }
        });
    }

    @Override
    public String getServiceName() {
        return "research-center-fourth-server";
    }

    @Override
    public String getApiPath() {
        return null; // 所有接口由本策略处理
    }

    @Override
    public ExportDataResponse<?> execute(HttpServletRequest request, Map<String, Object> queryParams, ExportReq exportReq) {
        TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>> func =
                pathMapping.get(exportReq.getApiPath());
        if (func == null) {
            return new ExportDataResponse<>(404, "未找到匹配的接口: " + exportReq.getApiPath(),
                    Collections.emptyList(), Collections.emptyList());
        }
        return func.apply(request, queryParams, exportReq);
    }
}