package com.zzsn.excelexportservice.exportStrategys;

import com.alibaba.fastjson2.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zzsn.excelexportservice.dto.ColumnParamVO;
import com.zzsn.excelexportservice.dto.ExportDataResponse;
import com.zzsn.excelexportservice.dto.ExportReq;


import com.zzsn.excelexportservice.feign.ClbColumFeign;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;


import java.util.*;

/**
 * @Author: lxj
 * @Date: 2025/9/30 11:37
 */
@Component
public class ClbStrategy implements ExportStrategy {

    @Resource
    private ClbColumFeign clbColumFeign;
    private final ObjectMapper mapper = new ObjectMapper();
    private final Map<String, TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>>> pathMapping = new HashMap<>();

    @PostConstruct
    public void init() {
        register("/channel/datapull/column/getEnterpriseDynamicNum/export/excel",
                (request, queryParams, exportReq) -> clbColumFeign.getEnterpriseDynamicNum(
                        mapper.convertValue(queryParams, ColumnParamVO.class)
                ));

        // 以后可以继续 put 其他 CMS 导出接口
    }

    private void register(String path,
                          TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>> func) {
        pathMapping.put(path, (request, queryParams, exportReq) -> {
            try {
                return func.apply(request, queryParams, exportReq);
            } catch (com.dtflys.forest.exceptions.ForestRuntimeException fre) {
                // Forest 调用异常，比如 token 过期或连接失败
                return new ExportDataResponse<>(2, "调用 column 接口失败：" + fre.getMessage(),
                        Collections.emptyList(), Collections.emptyList());
            } catch (Exception e) {
                // 其他不可预期的异常
                return new ExportDataResponse<>(3, "导出内部错误：" + e.getMessage(),
                        Collections.emptyList(), Collections.emptyList());
            }
        });
    }

    @Override
    public String getServiceName() {
        return "service-column";
    }

    @Override
    public String getApiPath() {
        return null; // 所有接口由本策略处理
    }

    @Override
    public ExportDataResponse<?> execute(HttpServletRequest request, Map<String, Object> queryParams, ExportReq exportReq) {
        TriFunction<HttpServletRequest, Map<String, Object>, ExportReq, ExportDataResponse<?>> func =
                pathMapping.get(exportReq.getApiPath());
        if (func == null) {
            return new ExportDataResponse<>(404, "未找到匹配的接口: " + exportReq.getApiPath(),
                    Collections.emptyList(), Collections.emptyList());
        }
        return func.apply(request, queryParams, exportReq);
    }
}