package com.zzsn.excelexportservice.dto;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ColumnParamVO {
    //数据权限栏目标识
    private String flagCode;
    private String id;

    //专题id
    private String subjectId;

    //文章链接
    private String url;

    //专题标题
    private String title;

    //专题摘要
    private String summary;

    //内容
    private String content;

    //作者
    private String author;

    //发布时间
    private String publishDate;

    //来源
    private String origin;

    //国家
    private String country;

    //得分
    private String score;

    //企业名称
    private String enterpriseName;

    //信息类型
    private String InfoType;

    //专题库类型
    private String libraryType;

    //置顶标识（0取消置顶 1置顶）
    private Integer type;

    private String sourceAddress;

    //开始时间
    private String startTime;

    //企业代码
    private String socialCreditCode;
    //地区名称
    private String regionName;
    //结束时间
    private String endTime;

    //专题库类型(1：政策；2：领导讲话；3：专家观点；4：企业案例)
    private Integer classificationType;
    private String classificationTypes;
    //审核操作(0：未审核  1：审核通过  2：审核未通过  3：暂定  默认值为0)
    private List<Integer> checkStatusList;
    private Integer checkStatus;

    //删除标记(1:删除；0:保留)
    private Integer deleteFlag = 0;

    //用户id
    private String userId;

    //项目id、栏目id、栏目组id
    private String columnId;

    //是否音频、视频
    private String video = "";

    //搜索内容
    private String searchInfo = "";

    //排序的列 ["score"(相关性)，"publishDate"(发布时间)]
    private String column = "common";

    //排序字段  [desc|asc]默认desc
    private String order = "desc";

    //页码
    private Integer pageNo = 1;
    private Integer pageNo2;
    private Integer pageNo3;
    //页大小
    private Integer pageSize = 10;

    //是否所有
    private String ynAll = "";

    //是否是栏目
    private String ynChannel = "0";

    //是否是项目
    private String ynProject = "0";

    //筛选的栏目id
    private String channelId = "";
    /**标签*/
    List<Label> labels;

    //关键词检索范围 [1标题  2正文 3 全部]
    private  Integer searchScope;
    //精确度["精确"| --]
    private String searchAccuracy;

    //操作类型 add .update
    private String action;

    //日期最大值
    private String maxValue;

    //字段
    private String fields;
    //倾向性
    private String orientation;
    //是否支持组合查询
    private Boolean multiLabel =false;
    //数据所在的索引名称
    private String index;

    /**
     * 榜单id，多个之间,分割
     */
    private String rankings;
    private String typeName;
    /**
     * 使用机构脚本 1:使用机构排序脚本
     */
    private String useOriginScript;

    /**
     * 用户选择的文章id
     */
    private List<String> articleIds;
}
