package com.zzsn.excelexportservice.controller;

import com.zzsn.excelexportservice.dto.ExportReq;
import com.zzsn.excelexportservice.service.ExcelExportService;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;


import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Author: lxj
 * @Date: 2025/9/18 11:09
 */
@RestController
@RequestMapping("/export")
@RequiredArgsConstructor
public class ExcelExportController {
    @Resource
    private  ExcelExportService excelExportService;

    @PostMapping("/excel")
    public void exportExcel(@RequestBody List<ExportReq> exportReqList, HttpServletRequest request, HttpServletResponse response) {
        excelExportService.export(exportReqList,request, response);
    }
}
