package com.zzsn.excelexportservice.feign;

import com.zzsn.excelexportservice.dto.CountryReq;
import com.zzsn.excelexportservice.dto.ExportDataResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author: lxj
 * @Date: 2025/9/25 16:15
 */
@FeignClient(name = "international-operation"
        , url = "${excel.export.services.international-operation.data-url}"
)
public interface InternationalFeign {
    @GetMapping("/international/country/generalInfo/export/excel")
    ExportDataResponse getCountryInfoExport(@RequestParam("country") String country);

    @PostMapping("/international/country/merchandise/export/excel")
    ExportDataResponse merchandiseExport(@RequestBody CountryReq req);

    @PostMapping("/international/country/getTradeServ/export/excel")
    ExportDataResponse getTradeServExport(@RequestBody CountryReq req);

    @PostMapping("/international/country/getTradeServ/category/export/excel")
    ExportDataResponse getTradeServCategoryExport(@RequestBody CountryReq req);

    @PostMapping("/international/country/getTradeIndices/export/excel")
    ExportDataResponse getTradeIndicesExport(@RequestBody CountryReq req);

    @PostMapping("/international/country/getEconomic/export/excel")
    ExportDataResponse getEconomicExport(@RequestBody CountryReq req);

    @PostMapping("/international/country/getEconomic/Expenditure/export/excel")
    ExportDataResponse getEconomicExpenditureExport(@RequestBody CountryReq req);

    @PostMapping("/international/country/getFdiAndExternal/export/excel")
    ExportDataResponse getFdiAndExternal(@RequestBody CountryReq req);

    @PostMapping("/international/country/getFdiAndExternal/capitalFlow/export/excel")
    ExportDataResponse getFdiAndExternalCapitalFlowExport(@RequestBody CountryReq req);

    @PostMapping("/international/country/getGoodsAndServ/export/excel")
    ExportDataResponse getGoodsAndServExport(@RequestBody CountryReq req);

    @PostMapping("/international/country/getGoodsAndServ/openness/export/excel")
    ExportDataResponse getGoodsAndServOpennessExport(@RequestBody CountryReq req);

    @PostMapping("/international/country/getLivingArea/export/excel")
    ExportDataResponse getLivingAreaExport(@RequestBody CountryReq req);

    @PostMapping("/international/country/getOther/export/excel")
    ExportDataResponse getOtherExport(@RequestBody CountryReq req);

    @PostMapping("/international/country/getOther/economy/export/excel")
    ExportDataResponse getOtherEconomyExport(@RequestBody CountryReq req);
}
