package com.zzsn.excelexportservice.dto;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ColumnParamSeniorVo {
    private String id;

    private List<String> ids;

    //专题id
    private String subjectId;

    //文章链接
    private String url;

    //专题标题
    private String title;

    //专题摘要
    private String summary;

    //内容
    private String content;

    //作者
    private String author;

    //发布时间
    private String publishDate;

    //来源
    private String origin;

    //得分
    private String score;

    //企业名称
    private String enterpriseName;

    //信息类型
    private String InfoType;

    //专题库类型
    private String libraryType;

    //置顶标识（0取消置顶 1置顶）
    private Integer type;

    private String sourceAddress;

    //开始时间
    private String startTime;

    //结束时间
    private String endTime;

    //专题库类型(1：政策；2：领导讲话；3：专家观点；4：企业案例)
    private Integer classificationType;

    //审核操作(0：未审核  1：审核通过  2：审核未通过  3：暂定  默认值为0)
    private List<Integer> checkStatusList;
    private Integer checkStatus;

    //删除标记(1:删除；0:保留)
    private Integer deleteFlag = 0;

    //用户id
    private String userId;

    //项目id、栏目id、栏目组id
    private String columnId;

    //是否音频、视频
    private String video = "";

    //搜索内容
    private String searchInfo = "";

    //排序的列 ["score"(相关性)，"publishDate"(发布时间) "all"(综合)]
    private String column = "publishDate";

    //排序字段  [desc|asc]默认desc
    private String order = "desc";

    //页码
    private Integer pageNo = 1;

    //页大小
    private Integer pageSize = 10;

    //是否所有
    private String ynAll = "";

    //是否是栏目
    private String ynChannel = "1";

    //是否是项目
    private String ynProject = "0";

    //筛选的栏目id
    private String channelId = "";
    /**标签*/
    List<Label> labels;

    //关键词检索范围 [1标题  2正文 3 全部]
    private  Integer searchScope;
    //精确度["精确"| --]
    private String searchAccuracy;
    //专家搜索类型（1全部、2姓名、3机构 4标签	5领域  6资讯）通过字典接口获取
    private  Integer searchType;
    //操作类型 add .update
    private String action;

    //日期最大值
    private String maxValue;

    //字段
    private String fields;
    //倾向性
    private String orientation;
    //是否支持组合查询
    private Boolean multiLabel =false;

    //专家部门
    private String department;

    //专家部门
    private String expertType;

    //去除前几条
    private Integer from = 0;
    //栏目编码
    private String flagCode;
    //数据索引
    private String index;

    //专家分类id
    private List<String> typeId;
    //专家审核状态（默认查询待审核与审核通过）
    private List<String> auditStatus = Arrays.asList("2");
    //查询关键词
    private String keyWords;
    //人物id
    private String uid;
    //标签集合
    private Map<String,List<LinkedHashMap>> tagList;
    //是否核心
    private Boolean ynCore = true;

    //queryType 0 -500强 1-重点企业 2-智能写作专题 3-reits专题  4-栏目查询（四期服务参数要求）
    private String queryType="4";
    //开始日期
    private String startDate="1900-01-01T00:00:00";
    //查询资讯数量
    private Integer articleNum;
    //结束日期
    private String endDate;
    //查询热词个数
    private Integer count;
    //选中的资讯id集合
    private List<String> articleIds;
    /*
     * 关键词
     * */
    private String keyword;



    //图谱相关参数-节点层级、每种节点数量、每种节点占比
    private String nodeId;
    private String nodeLabel;
    private String nodeName;

    private Integer level = 1;
    private Integer expertNodeNumber = 5;
    private Integer institutionNodeNumber = 5;
    private Integer keywordNodeNumber = 5;
    private Integer researchAreaNodeNumber = 5;

    private Integer expertNodeRatio = 20;
    private Integer institutionNodeRatio = 20;
    private Integer keywordNodeRatio = 20;
    private Integer researchAreaNodeRatio = 20;
}
