package com.zzsn.thinktank.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.thinktank.entity.ThinktankBasicInfo;
import com.zzsn.thinktank.vo.Result;
import com.zzsn.thinktank.vo.ThinktankBasicInfoListVo;
import com.zzsn.thinktank.vo.ThinktankBasicInfoVo;
import com.zzsn.thinktank.vo.ThinktankInfoVo;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/4/24 10:31
 * @Content:
 */
public interface ThinktankBasicInfoService extends IService<ThinktankBasicInfo> {

    Result<?> add(ThinktankBasicInfo thinktankBasicInfo);

    Result<?> del(String id);

    Result<?> edit(ThinktankBasicInfo thinktankBasicInfo);

    ThinktankBasicInfoVo getInfoById(String id);

    ThinktankInfoVo getThinktankBasicInfoById(String id);

    Result<?> getList(ThinktankBasicInfoListVo thinktankBasicInfoListVo);

    void downloadTemplate(HttpServletResponse response);

    Result batchImport(MultipartFile multipartFile);

    byte[] batchExport(ThinktankBasicInfoListVo thinktankBasicInfoListVo, HttpServletRequest request, HttpServletResponse response);

    Result<?> getListBaseData(String id, Integer pageNo, Integer pageSize, Integer office);

    IPage<ThinktankBasicInfo> pageList(Integer pageNo,Integer pageSize,ThinktankBasicInfoListVo vo, HttpServletRequest req) throws Exception;

    List<Map<String,Object>> queryStatisticalAnalysis(String type,Page page, ThinktankBasicInfoListVo vo, HttpServletRequest req);
}
