package com.zzsn.thinktank.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.thinktank.entity.ThinktankBasicInfo;
import com.zzsn.thinktank.service.ThinktankBasicInfoService;
import com.zzsn.thinktank.util.AccessTokenUtil;
import com.zzsn.thinktank.vo.Result;
import com.zzsn.thinktank.vo.ThinktankBasicInfoListVo;
import com.zzsn.thinktank.vo.ThinktankBasicInfoVo;
import com.zzsn.thinktank.vo.ThinktankInfoVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.util.WebUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/4/24 10:28
 * @Content:
 */
@Slf4j
@RestController
@RequestMapping("/api/basicinfo")
public class ThinktankBasicInfoController {

    @Autowired
    ThinktankBasicInfoService thinktankBasicInfoService;


    /**
     * 新增
     * @param thinktankBasicInfo
     * @return
     */
    @PostMapping("/add")
    public Result<?> add(@RequestBody ThinktankBasicInfo thinktankBasicInfo){
        log.info("新增信息：{}",thinktankBasicInfo);
        return thinktankBasicInfoService.add(thinktankBasicInfo);
    }

    /**
     * 根据id主键删除
     * @param id
     * @return
     */
    @GetMapping("/del")
    public Result<?> del(@RequestParam(name="id",required=true) String id){
        log.info("根据id删除:{}", id);
        return thinktankBasicInfoService.del(id);
    }

    /**
     * 根据id修改信息
     * @param thinktankBasicInfo
     * @return
     */
    @PostMapping("/edit")
    public Result<?> edit(@RequestBody ThinktankBasicInfo thinktankBasicInfo){
        log.info("根据id修改信息:{}",thinktankBasicInfo);
        if(thinktankBasicInfo.getId() == null)
            return Result.error(400, "id不能为空");
        return thinktankBasicInfoService.edit(thinktankBasicInfo);
    }

    /**
     * 根据id主键查询
     * @param id
     * @return
     */
    @GetMapping("getById")
    public Result<?> getById(@RequestParam(name="id",required=true) String id){
        log.info("根据id主键查询:{}",id);
        ThinktankBasicInfoVo thinktankBasicInfo = thinktankBasicInfoService.getInfoById(id);
        return Result.OK(thinktankBasicInfo);
    }

    /**
     * 根据id主键查询智库信息
     * @param id
     * @return
     */
    @GetMapping("info")
    public Result<?> getThinktankBasicInfoById(@RequestParam(name="id",required=true) String id, HttpServletRequest request) {
        String userId = "";
        try {
            userId = AccessTokenUtil.getUserIdFromAccessToken(request);
        } catch (Exception e) {
            if (userId == null || "".equals(userId)) {
                userId = request.getSession().getId();
            }
        }
        ThinktankInfoVo thinktankInfoVo = thinktankBasicInfoService.getThinktankBasicInfoById(id,userId);
        return Result.OK(thinktankInfoVo);
    }

    /**
     * 收藏/取消收藏
     * @param id
     * @return
     */
    @GetMapping("collect")
    public Result<?> collect(@RequestParam(name="id",required=true) String id, HttpServletRequest request) {
        String userId = "";
        try {
            userId = AccessTokenUtil.getUserIdFromAccessToken(request);
        } catch (Exception e) {
            if (userId == null || "".equals(userId)) {
                userId = request.getSession().getId();
            }
        }
        thinktankBasicInfoService.collect(id,userId);
        return Result.OK("操作成功");
    }

    /**
     * 智库关联ott
     * @param baseCode 智库编码
     * @param ottCode ott主键
     * @return
     */
    @GetMapping("relation")
    public Result<?> relation(String baseCode, String ottCode) {
        thinktankBasicInfoService.relation(baseCode,ottCode);
        return Result.OK("操作成功");
    }

    /**
     * 已收藏智库列表
     * @return
     */
    @GetMapping("collectList")
    public Result<?> collectList(HttpServletRequest request) {
        String userId = "";
        try {
            userId = AccessTokenUtil.getUserIdFromAccessToken(request);
        } catch (Exception e) {
            if (userId == null || "".equals(userId)) {
                userId = request.getSession().getId();
            }
        }
        List<ThinktankBasicInfo> thinktankBasicInfos = thinktankBasicInfoService.collectList(userId);
        return Result.OK(thinktankBasicInfos);
    }


    @PostMapping("/list")
    public Result<?> getList(@RequestBody ThinktankBasicInfoListVo thinktankBasicInfoListVo){
        log.info("智库信息条件分页查询:{}", thinktankBasicInfoListVo);
        Integer pageNo = thinktankBasicInfoListVo.getPageNo();
        Integer pageSize= thinktankBasicInfoListVo.getPageSize();
        if(pageNo < 1)
            pageNo = 1;
        if(pageSize < 0)
            pageSize = 10;
        Integer office = pageSize * (pageNo - 1);
        thinktankBasicInfoListVo.setOffset(office);
        return thinktankBasicInfoService.getList(thinktankBasicInfoListVo);
    }


    /**
     * 智库列表（yjzx）
     */
    @PostMapping("/queryPageList")
    public Result<?> queryPageList(@RequestBody(required = false) ThinktankBasicInfoListVo vo,
                                   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
                                   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
                                   HttpServletRequest req) throws Exception {
        IPage<ThinktankBasicInfo> pageList = thinktankBasicInfoService.pageList(pageNo,pageSize,vo,req);
        return Result.OK(pageList);
    }


    /**
     * 智库区域/国别/领域统计分析（yjzx）
     * @param type(continent按洲   country按国家  tag按领域)
     */
    @GetMapping("/queryStatisticalAnalysis")
    public Result<?> queryStatisticalAnalysis(String type,HttpServletRequest req) throws Exception {
        ThinktankBasicInfoListVo vo = new ThinktankBasicInfoListVo();
        Page<ThinktankBasicInfo> page = new Page<ThinktankBasicInfo>(1, 999999);
        List<Map<String,Object>> mapList = thinktankBasicInfoService.queryStatisticalAnalysis(type,page,vo,req);
        return Result.OK(mapList);
    }

    /**
     * 模板下载
     * @param response
     */
    @GetMapping("/downloadTemplate")
    public void downloadTemplate(HttpServletResponse response) {
        thinktankBasicInfoService.downloadTemplate(response);
    }

    /**
     * 批量导入数据
     * @param
     * @return
     */
    //@Transactional
    @PostMapping("/batchImport")
    public Result<?> batchImport( HttpServletRequest request) {
        log.info("批量导入数据");
//        log.info("批量导入数据:{}",file.getOriginalFilename());
//        log.info("file:{}",file.getName());

        MultipartHttpServletRequest multipartRequest = WebUtils.getNativeRequest(request, MultipartHttpServletRequest.class);

        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        log.info(fileMap.size() + "");



//        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
//        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
//        log.info("file size:{}",fileMap.size());
//        if (fileMap.size() < 1) {
//            return Result.error("请上传文件!");
//        }
        MultipartFile multipartFile = fileMap.get(new ArrayList<>(fileMap.keySet()).get(0));
        Result result = thinktankBasicInfoService.batchImport(multipartFile);
//        Result result = thinktankBasicInfoService.batchImport(file);
        return  result;

    }

    @PostMapping("/batchExport")
    public byte[] batchExport(@RequestBody ThinktankBasicInfoListVo thinktankBasicInfoListVo,HttpServletRequest request, HttpServletResponse response){
        log.info("导出:{}", thinktankBasicInfoListVo);
//        Integer pageNo = thinktankBasicInfoListVo.getPageNo();
//        Integer pageSize= thinktankBasicInfoListVo.getPageSize();
//        if(pageNo < 1)
//            pageNo = 1;
//        if(pageSize < 0)
//            pageSize = 10;
//        Integer office = pageSize * (pageNo - 1);
//        thinktankBasicInfoListVo.setOffset(office);
        return thinktankBasicInfoService.batchExport(thinktankBasicInfoListVo,request,response);
    }

    @GetMapping("/listBaseData")
    public Result<?> getListBaseData(@RequestParam(name="id",required=true) String id,
                                     @RequestParam(name="pageNo",required=true) Integer pageNo,
                                     @RequestParam(name="pageSize",required=true) Integer pageSize){
        log.info("智库成果分页查询:{}", id);
        if(pageNo < 1)
            pageNo = 1;
        if(pageSize < 0)
            pageSize = 10;
        Integer office = pageSize * (pageNo - 1);
        return thinktankBasicInfoService.getListBaseData(id,pageNo,pageSize,office);
    }


    /**
     * 智库维护
     * @return
     */
    @PostMapping("importExcel")
    public Result think(MultipartFile file) {
        thinktankBasicInfoService.thinkTank(file);
        return Result.OK();
    }

}
