package com.zzsn.thinktank.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 信息源表
 * </p>
 *
 * @author obcy
 * @since 2025-06-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("info_source_main")
public class InfoSourceMain extends Model<InfoSourceMain> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 信息源编码
     */
    @TableField("code")
    private String code;

    /**
     * 信息源名称
     */
    @TableField("info_name")
    private String infoName;

    /**
     * 类型
     */
    @TableField("type")
    private Integer type;

    /**
     * 地址
     */
    @TableField("info_address")
    private String infoAddress;

    /**
     * 别名
     */
    @TableField("alias")
    private String alias;

    /**
     * 是否原创性校验1 校验 0否
     */
    @TableField("original_check")
    private Integer originalCheck;

    /**
     * 校验列表
     */
    @TableField("check_list")
    private String checkList;

    /**
     * 主办单位
     */
    @TableField("organizer")
    private String organizer;

    /**
     * 地区全路径
     */
    @TableField("area_full_paths")
    private String areaFullPaths;

    /**
     * 地区名称
     */
    @TableField("area")
    private String area;

    /**
     * 是否翻墙
     */
    @TableField("skip_wall")
    private Integer skipWall;

    /**
     * 网站刷新速度
     */
    @TableField("refresh_speed")
    private Integer refreshSpeed;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private Date updateTime;

    /**
     * 创建人
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 更新人
     */
    @TableField("update_by")
    private String updateBy;

    @TableField("del_flag")
    @TableLogic
    private Integer delFlag;

    /**是否免过关键词  0否   1是*/
    @TableField(exist = false)
    private Integer isExemptKeyword;
    /**是否免审核 0否  1是*/
    @TableField(exist = false)
    private Integer isFreeCheck;
    /**专题绑定的信息源的类型，定向或者非定向*/
    @TableField(exist = false)
    private String subjectInfoSourceType;
    /**
     * 信息源类别
     */
    @TableField(exist = false)
    private Integer sourceType;
    /**
     * 专题绑定信息源的主键id
     */
    @TableField(exist = false)
    private String subjectInfoSourceId;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
