package com.zzsn.thinktank.util;

import org.apache.commons.lang3.time.DateUtils;

import java.text.ParseException;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/4/3 11:08
 * @Content: 日期处理
 */
public class DateUtil {

    /**
     * 支持的日期格式
     */
    private static final String[] froms = {"yyyy","yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"};

    /**
     * 根据支持的日期格式校验字符串是否符合格式
     * @param dateStr
     * @return 通过校验返回true, 未通过校验返回false
     */
    public static boolean isValidDate(String dateStr){

        try {
            DateUtils.parseDateStrictly(dateStr, froms);
            return true;
        } catch (ParseException e) {
            return false;
        }
    }

    /**
     * 根据支持的日期格式校验字符串是否符合格式
     * @param dateStr
     * @return 通过校验返回true, 未通过校验返回false ,如果待校验字符串未空，则返回true
     */
    public static boolean isDate(String dateStr){
        if(dateStr != null && dateStr.length() > 0){
            return isValidDate(dateStr);
        } else {
            return true;
        }
    }
}
