package com.zzsn.thinktank.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.thinktank.entity.InfoSourceGroupMap;
import com.zzsn.thinktank.vo.ThinkTankSourceVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 信息源组和信息源关联表
 * @Author: jeecg-boot
 * @Date:   2021-11-24
 * @Version: V1.0
 */
public interface InfoSourceGroupMapMapper extends BaseMapper<InfoSourceGroupMap> {

    InfoSourceGroupMap query(@Param("sourceId") String sourceId, @Param("groupId") String groupId);

    void deleteBySourceId(@Param("sourceId") String sourceId);

    void deleteBySourceIds(@Param("groupId") String groupId, @Param("sourceIds") List<String> sourceIds);

    /**
     * 获取智库关联的信息源集合
     *
     * @param groupIds 智库id集合
     * @author lkg
     * @date 2024/8/23
     */
    List<ThinkTankSourceVO> listOfThinkTank(@Param("groupIds") List<String> groupIds);
}
