package com.zzsn.thinktank.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 国家地域表
 * @Author: jeecg-boot
 * @Date:   2022-02-09
 * @Version: V1.0
 */
@Data
@TableName("sys_base_region")
public class SysBaseRegion implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    private String id;
	/**中文名称*/
	@Excel(name = "中文名称", width = 15)
    private String nameCn;
	/**中文标签*/
	@Excel(name = "中文标签", width = 15)
    private String aliaCn;
	/**英文名称*/
	@Excel(name = "英文名称", width = 15)
    private String nameEn;
	/**英文标签*/
	@Excel(name = "英文标签", width = 15)
    private String aliaEn;
	/**经度*/
	@Excel(name = "经度", width = 15)
    private String longitude;
	/**纬度*/
	@Excel(name = "纬度", width = 15)
    private String latitude;
	/**所属洲*/
	@Excel(name = "所属洲", width = 15)
    private String continent;
	/**所属洲英文*/
	@Excel(name = "所属洲英文", width = 15)
    private String continentEn;
	/**所属洲二级中文名*/
	@Excel(name = "所属洲二级中文名", width = 15)
    private String continentSub;
	/**所属洲二级英文名称*/
	@Excel(name = "所属洲二级英文名称", width = 15)
    private String continentSubEn;
	/**国家代码*/
	@Excel(name = "国家代码", width = 15)
    private String code;
	/**货币*/
	@Excel(name = "货币", width = 15)
    private String currency;
	/**官方语言*/
	@Excel(name = "官方语言", width = 15)
    private String lang;
	/**时区*/
	@Excel(name = "时区", width = 15)
    private String timezone;
	/**国土面积*/
	@Excel(name = "国土面积", width = 15)
    private Integer area;
	/**人口数量*/
	@Excel(name = "人口数量", width = 15)
    private Integer population;
	/**描述*/
	@Excel(name = "描述", width = 15)
    private String regionDesc;
	/**地区描述英文*/
	@Excel(name = "地区描述英文", width = 15)
    private String regionDescEn;
	/**创建人*/
    private String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
	/**更新人*/
    private String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
	/**所属部门*/
    private String sysOrgCode;
	/**父级节点*/
	@Excel(name = "父级节点", width = 15)
    private String pid;
	/**是否有子节点*/
	@Excel(name = "是否有子节点", width = 15, dicCode = "yn")
    private String hasChild;
	/**层级路径id集合*/
	@Excel(name = "层级路径id集合", width = 15)
    private String pathIds;
	/**层级路径id集合*/
	@Excel(name = "等级id", width = 15)
    private String levelId;
}
