package com.zzsn.thinktank.controller;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.thinktank.constants.CommonConstants;
import com.zzsn.thinktank.entity.SysDict;
import com.zzsn.thinktank.entity.SysDictItem;
import com.zzsn.thinktank.entity.ThinktankBasicInfo;
import com.zzsn.thinktank.service.ISysDictItemService;
import com.zzsn.thinktank.service.ISysDictService;
import com.zzsn.thinktank.service.ThinktankBasicInfoService;
import com.zzsn.thinktank.vo.Result;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @Author zhangweijian
 * @since 2018-12-28
 */
@RestController
@RequestMapping("/sys/dictItem")
@Slf4j
public class SysDictItemController {
	@Autowired
	ThinktankBasicInfoService thinktankBasicInfoService;
	@Autowired
	private ISysDictItemService sysDictItemService;
	@Autowired
	private ISysDictService sysDictService;

	/**
	 * @功能：查询字典数据
	 * @param sysDictItem
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@PostMapping(value = "/remoteList")
	public Result<IPage<SysDictItem>> remoteList(@RequestBody SysDictItem sysDictItem,
													@RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
													@RequestParam(name="pageSize", defaultValue="10") Integer pageSize,HttpServletRequest req) {
		Result<IPage<SysDictItem>> result = new Result<IPage<SysDictItem>>();
		QueryWrapper query = new QueryWrapper();
		query.eq("dict_code",sysDictItem.getDictCode());
		SysDict sysDict = sysDictService.getOne(query);
		if(sysDict!=null){
			LambdaQueryWrapper<SysDictItem> queryWrapper = new LambdaQueryWrapper<SysDictItem>()
					.eq(null != sysDictItem.getStatus(), SysDictItem::getStatus, sysDictItem.getStatus())
					.eq(null != sysDict.getId(), SysDictItem::getDictId, sysDict.getId())
					.like(null != sysDictItem.getItemText(), SysDictItem::getItemText, sysDictItem.getItemText());
			//查询智库筛选条件为语言时，只返回智库现有语言
			if(sysDict.getDictCode().equals("language")){
				QueryWrapper queryThink = new QueryWrapper();
				queryThink.eq("status",1);
				queryThink.eq("yn_display",1);//yjzx-是否展示到列表（0否 1是）
				queryThink.groupBy("lang");
				queryThink.select("lang");
				List<ThinktankBasicInfo> thinktankBasicInfo = thinktankBasicInfoService.list(queryThink);
				// 使用 Stream API 遍历集合，过滤掉 lang 为 null 或空的元素，并收集剩余元素的 lang 字段，用英文逗号隔开
				String langValues = thinktankBasicInfo.stream()
						.filter(baseInfo->baseInfo!=null)
						.map(ThinktankBasicInfo::getLang) // 提取 lang 字段
						.filter(lang -> lang != null && !lang.isEmpty()) // 过滤掉 null 或空的值
						.collect(Collectors.joining(",")); // 将结果用英文逗号连接起来
				// 使用 Stream API 去重并重新拼接字符串
				List<String> distinctLangValuesList = Arrays.stream(langValues.split(","))
						.distinct()
						.collect(Collectors.toList());
				queryWrapper.in(SysDictItem::getItemValue,distinctLangValuesList);
			}else if(sysDict.getDictCode().equals("Influence")){
				queryWrapper.ne(SysDictItem::getItemValue, CommonConstants.INFLUENCE_3);//特殊需求,过滤颠覆性重点智库
			}
			queryWrapper.eq(SysDictItem::getStatus,1);
			Page<SysDictItem> page = new Page<SysDictItem>(pageNo, pageSize);
			IPage<SysDictItem> pageList = sysDictItemService.page(page, queryWrapper);
			result.setSuccess(true);
			result.setResult(pageList);
		}
		return result;
	}
	
}
