package com.zzsn.thinktank.vo;

import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 *5.1 人物分类体系表 character_category_structure
 * </p>
 *
 * @since
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ThinktankCategoryStructureVo implements Serializable
 {

    /**
     * 主键
     */
    private String id;

    /**
     * 类别名称 公安部 财政部
     */
    private String typeName;

    /**
     *类别编码
     */
    private String typeCode;

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 更新人
     */
    @TableField("")
    private String updateBy;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /**
     * 所属部门
     */
    private String sysOrgCode;

    /**
     * 父级节点id
     */
    private String pid;

    /**
     * 是否有子节点0，没有 1，有
     */
    private String hasChild;

    /**
     * 分类类型:	领导人 专家 企业高管
     */
    private String category;

    /**
     * 状态0启用，1禁用
     */
    private Integer status;

    /**
     * 节点绝对路径
     */
    private String fullPath;

    /**
     * 描述
     */
    private String description;

    /**
     * 排序
     */
    private Long sort;

    /**
     * 智库数量
     */
    private Integer thinktankCount;

 }
