package com.zzsn.thinktank.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.List;

@Data
public class InfoSourceGroupPage {
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    private String id;
    /**
     * 组编码
     */
    @Excel(name = "组编码", width = 15)
    private String groupCode;
    /**
     * 信息源组名称
     */
    @Excel(name = "信息源组名称", width = 15)
    private String groupName;

    /**
     * 绑定信息源组的信息源ids
     */
    @Excel(name = "绑定信息源组的信息源ids", width = 15)
    private List<String> infoSourceIds;

    /**
     * 组类别id
     */
    @Excel(name = "组类别ids", width = 15)
    private List<String> groupTypeIds;

    private String typeIds;
    private String typeId;

    /**
     * 组类别名称
     */
    @Excel(name = "组类别名称", width = 15)
    private String groupTypeNames;

    /**
     * 分组说明
     */
    @Excel(name = "分组说明", width = 15)
    private String groupRemark;
    /**
     * 状态
     */
    @Excel(name = "状态", width = 15, dicCode = "use_status")
    private Integer status;
    /**
     * 创建人
     */
    private String createBy;
    /**
     * 创建日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private java.util.Date createTime;
    /**
     * 更新人
     */
    private String updateBy;
    /**
     * 更新日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private java.util.Date updateTime;
    /**
     * 所属部门
     */
    private String sysOrgCode;

    /**
     * 信息源类别
     */
    private Integer sourceType;

    /**
     * 信息源权重（以组设置）
     */
    private Integer weight;

    /**
     * 专题绑定信息源的主键id
     */
    private String subjectInfoSourceId;
    private Integer infoSourceNum;
    private String groupTypeId;

}
