#!/bin/sh

set -eu

. ./.env

username="${repo_username}"
passwd="${repo_passwd}"
dir="${root_dir}/${svc_name}/${svc_env}"
name="${svc_name}-${svc_env}"

echo "构建名称: ${name}"
echo "构建版本: ${version}"
echo "推送仓库: ${domain}/${namespace}"

echo "构建镜像"
docker build -f ./build/${svc_env}/Dockerfile -t ${domain}/${namespace}/${name}:${version} .

echo "推送镜像"
docker login -u=$username -p=${passwd} ${domain}
docker push ${domain}/${namespace}/${name}:${version}

echo "清理none镜像"
docker image prune -af
