package com.zzsn.thinktank.service.impl;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.thinktank.entity.PolicySpecialInformation;
import com.zzsn.thinktank.entity.ThinktankBasicInfo;
import com.zzsn.thinktank.entity.ThinktankCategoryStructure;
import com.zzsn.thinktank.mapper.LeaderCategoryMapper;
import com.zzsn.thinktank.service.LeaderCategoryService;
import com.zzsn.thinktank.service.ThinktankBasicInfoService;
import com.zzsn.thinktank.util.EsUtil;
import com.zzsn.thinktank.util.SimRedisUtil;
import com.zzsn.thinktank.vo.*;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.*;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * <p>
 *  分类树服务实现类
 * </p>
 *
 * @author
 * @since
 */
@Service
public class LeaderCategoryServiceImpl extends ServiceImpl<LeaderCategoryMapper, ThinktankCategoryStructure> implements LeaderCategoryService {
    @Autowired
    @Qualifier("elasticsearch1Client")
    RestHighLevelClient client;
    @Autowired
    ThinktankBasicInfoService thinktankBasicInfoService;
    @Resource
    private SimRedisUtil simRedisUtil;
    private final static String KEY = "thinkTank:listTop10";
    @Override
    @Transactional
    public Result<?> add(ThinktankCategoryStructure characterCategoryStructure) {
        //判断是否有父节点，没有则为根节点，pid的值为0
        if (StringUtils.isBlank(characterCategoryStructure.getPid())){
            characterCategoryStructure.setPid(LeaderCategoryService.ROOT_PID_VALUE);
        }else {
            ThinktankCategoryStructure parent = super.getById(characterCategoryStructure.getPid());
            if(parent!=null && !LeaderCategoryService.HASCHILD.equals(parent.getHasChild())){
                parent.setHasChild(LeaderCategoryService.HASCHILD);
                super.updateById(parent);
            }
        }
        //characterCategoryStructure.setStatus(0);
        characterCategoryStructure.setHasChild(LeaderCategoryService.NOCHILD);
        /**第一次保存赋默认值*/
        characterCategoryStructure.setFullPath("0");
        characterCategoryStructure.setCreateTime(new Date());
        super.save(characterCategoryStructure);
        if (LeaderCategoryService.ROOT_PID_VALUE.equals(characterCategoryStructure.getPid())){
            characterCategoryStructure.setFullPath(characterCategoryStructure.getId());
        }else {
            ThinktankCategoryStructure parent = super.getById(characterCategoryStructure.getPid());
            characterCategoryStructure.setFullPath(parent.getFullPath() +","+ characterCategoryStructure.getId());
        }
        super.updateById(characterCategoryStructure);
        return Result.OK();
    }


    @Override
    @Transactional
    public Result<?> edit(ThinktankCategoryStructure characterCategoryStructure) {
        ThinktankCategoryStructure byId = super.getById(characterCategoryStructure.getId());
        if (ObjectUtils.isEmpty(byId)){
            return Result.error("未找到对应的分类id");
        }
        String oldPid = byId.getPid();
        String newPid = characterCategoryStructure.getPid();
        if(!oldPid.equals(newPid)) {
            /**处理之前父节点的hasChild字段*/
            updateOldParentNode(oldPid);

            if(StringUtils.isBlank(newPid) || LeaderCategoryService.ROOT_PID_VALUE.equals(newPid)){
                characterCategoryStructure.setPid(LeaderCategoryService.ROOT_PID_VALUE);
                newPid = characterCategoryStructure.getPid();
            }
            /**处理新的父节点的hasChild字段*/
            if(!LeaderCategoryService.ROOT_PID_VALUE.equals(characterCategoryStructure.getPid())) {
                super.update(Wrappers.<ThinktankCategoryStructure>lambdaUpdate().set(ThinktankCategoryStructure::getHasChild,LeaderCategoryService.HASCHILD).eq(ThinktankCategoryStructure::getId,newPid));
            }
            characterCategoryStructure.setUpdateTime(new Date());
            super.updateById(characterCategoryStructure);


            /**处理本节点的所有子节点的绝对路径*/
            List<ThinktankCategoryStructure> list = super.list(Wrappers.<ThinktankCategoryStructure>lambdaQuery().like(ThinktankCategoryStructure::getFullPath,characterCategoryStructure.getId()));
            if (CollectionUtil.isNotEmpty(list)){
                String finalNewPid = newPid;
                if (!LeaderCategoryService.ROOT_PID_VALUE.equals(finalNewPid)) {
                    /**非根节点 移动到其他非根节点*/
                    ThinktankCategoryStructure projectPid = super.getById(finalNewPid);

                    if (!LeaderCategoryService.ROOT_PID_VALUE.equals(oldPid)) {
                        String id = characterCategoryStructure.getId();
                        String fullPath = characterCategoryStructure.getFullPath();
                        String replace = fullPath.replace(id, "");

                        list.forEach(e->{
                            e.setFullPath(projectPid.getFullPath()+"," + e.getFullPath().replace(replace, ""));
                        });
                    }else {
                        /**根节点 移动到其他非根节点*/
                        list.forEach(e->{
                            e.setFullPath(projectPid.getFullPath()+","+e.getFullPath());
                        });
                    }
                }else {
                    String id = characterCategoryStructure.getId();
                    String fullPath = characterCategoryStructure.getFullPath();
                    String replace = fullPath.replace(id, "");
                    /**移动到根节点*/
                    list.forEach(e->{
                        e.setFullPath(e.getFullPath().replace(replace, ""));
                    });
                }
            }
            super.updateBatchById(list);
        }else {
            characterCategoryStructure.setUpdateTime(new Date());
            super.updateById(characterCategoryStructure);
        }
        return Result.OK();

    }

    @Override
    public Result<?> del(String id) {
        ThinktankCategoryStructure byId = super.getById(id);
        super.remove(Wrappers.<ThinktankCategoryStructure>lambdaQuery().like(ThinktankCategoryStructure::getFullPath,id));
        if (StringUtils.isNotBlank(byId.getPid())&&!LeaderCategoryService.ROOT_PID_VALUE.equals(byId.getPid())){
            updateOldParentNodeDel(byId.getPid());
        }

        return Result.OK();
    }


    @Override
    public Result<?> lists(String sign, String pid, String category) {

            List<ThinktankCategoryStructure> characterCategoryStructure ;
            if ("1".equals(sign)&&"0".equals(pid)){
                characterCategoryStructure = super.list(Wrappers.<ThinktankCategoryStructure>lambdaQuery()
                        .eq(ThinktankCategoryStructure::getPid, LeaderCategoryService.ROOT_PID_VALUE)
                        .eq(StrUtil.isNotBlank(category),ThinktankCategoryStructure::getCategory,category));
            }else {
                characterCategoryStructure = super.list(Wrappers.<ThinktankCategoryStructure>lambdaQuery()
                        .eq(ThinktankCategoryStructure::getPid,pid)
                        .eq(StrUtil.isNotBlank(category),ThinktankCategoryStructure::getCategory,category));
            }
            return Result.OK(characterCategoryStructure);

    }

    @Override
    public Result<?> lists() {

        List<ThinktankCategoryStructureVo> list = baseMapper.lists();

        return Result.OK(list);

    }

    @Override
    public Result<?> listTop10(Integer num) {
        List<ThinktankCategoryStructureVo> cacheObject = (List<ThinktankCategoryStructureVo>)simRedisUtil.getCacheObject(KEY);
        if(cacheObject!=null){
            return Result.OK(cacheObject);
        }
        List<ThinktankCategoryStructureVo> listRes = new ArrayList<>();
        List<String> listStr = new ArrayList<>();
        listStr.add("1537739653432397825");
        listStr.add("1537739804779663362");
        listStr.add("1537739894227390465");
        listStr.add("1539190285641097217");
        try {
            BoolQueryBuilder builder = QueryBuilders.boolQuery();
            builder.must(QueryBuilders.matchPhraseQuery("deleteFlag", 0));
            builder.must(QueryBuilders.matchPhraseQuery("checkStatus", 1));

            BoolQueryBuilder builderQuery = QueryBuilders.boolQuery();
            for(String subjectId : listStr){
                builderQuery.should(QueryBuilders.matchPhraseQuery("subjectId", subjectId));
            }
            builder.must(builderQuery);

            BoolQueryBuilder nestedBoolQueryBuilder = QueryBuilders.boolQuery();
            nestedBoolQueryBuilder.filter(QueryBuilders.matchPhraseQuery("labels.labelMark", "ThinkTanks"));
            QueryBuilder nestedQueryBuilder = QueryBuilders.nestedQuery("labels", nestedBoolQueryBuilder, ScoreMode.None);
            builder.must(nestedQueryBuilder);

            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.from(0);
            searchSourceBuilder.size(99999);
            searchSourceBuilder.query(builder);
            String[] fetchFields = {"id", "labels"};
            searchSourceBuilder.fetchSource(fetchFields, null);
            //默认最大数量是10000，设置为true后，显示准确数量
            searchSourceBuilder.trackTotalHits(true);
            SearchRequest searchRequest = new SearchRequest("subjectdatabase");
            searchRequest.source(searchSourceBuilder);//设置查询请求
            //执行查询
            SearchResponse searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
            List<PolicySpecialInformation> list = new ArrayList<>();
            for (SearchHit documentFields : searchResponse.getHits().getHits()) {
                String queryInfo = documentFields.getSourceAsString();
                PolicySpecialInformation info = JSON.parseObject(queryInfo, PolicySpecialInformation.class);
                list.add(info);
            }
            if (list != null && list.size() > 0) {
                Map<String, Integer> countMap = new HashMap<>();
                for (int i = 0; i < list.size(); i++) {
                    PolicySpecialInformation policySpecialInformation = list.get(i);
                    List<Label> Labels = policySpecialInformation.getLabels();
                    for(Label label:Labels){
                        if(label.getLabelMark().equals("ThinkTanks")){
                            if (countMap.containsKey(label.getRelationName())) {
                                Integer count = countMap.get(label.getRelationName());
                                countMap.put(label.getRelationName(),count+1);
                            } else {
                                countMap.put(label.getRelationName(),1);
                            }
                        }
                    }

                }
                Set<String> keySet = countMap.keySet();
                for (String keyAsString : keySet) {
                    Integer count = countMap.get(keyAsString);
                    ThinktankCategoryStructureVo vo = new ThinktankCategoryStructureVo();
                    QueryWrapper query = new QueryWrapper();
                    query.eq("chinese_whole",keyAsString);
                    List<ThinktankBasicInfo> listThink = thinktankBasicInfoService.list(query);
                    if(listThink.size()>0){
                        vo.setId(listThink.get(0).getBelongCountryId());
                        vo.setTypeName(listThink.get(0).getBelongCountry());
                        vo.setThinktankCount(count);
                        listRes.add(vo);
                    }
                }
            }
            Map<String, ThinktankCategoryStructureVo> map = new HashMap<>();
            for (ThinktankCategoryStructureVo item : listRes) {
                ThinktankCategoryStructureVo existing = map.get(item.getId());
                if (existing == null) {
                    map.put(item.getId(), item);
                } else {
                    existing.setThinktankCount(existing.getThinktankCount() + item.getThinktankCount());
                }
            }
            List<ThinktankCategoryStructureVo> mergedList = new ArrayList<>(map.values());
            // 按照count降序排序，并只取前十条记录
            List<ThinktankCategoryStructureVo> sortedAndLimitedList = mergedList.stream()
                    .sorted(Comparator.comparingInt(ThinktankCategoryStructureVo::getThinktankCount).reversed())
                    .limit(10)
                    .collect(Collectors.toList());
            simRedisUtil.setCacheObject(KEY, sortedAndLimitedList,30L, TimeUnit.DAYS);
            return Result.OK(sortedAndLimitedList);
        } catch (Exception e) {
            log.error("获取发布机构聚合结果异常{}",e);
        }
        return Result.OK(listRes);
    }


    @Override
    public Result<?> getByName(String category, String typeName) {
        //根据名称模糊查询
        List<ThinktankCategoryStructure> characterCategoryStructure = super.list(Wrappers.<ThinktankCategoryStructure>lambdaQuery()
                .like(ThinktankCategoryStructure::getTypeName,typeName)
                .eq(StrUtil.isNotBlank(category),ThinktankCategoryStructure::getCategory,category));

        //根据所有子节点的pid路径查询所有父节点
        Set<String> idSet = new HashSet<>();
        for (ThinktankCategoryStructure categoryStructure : characterCategoryStructure) {
            String fullPath = categoryStructure.getFullPath();
            String[] pidArr = fullPath.split(",");
            idSet.addAll(Arrays.asList(pidArr));
        }
        List<ThinktankCategoryStructure> characterCategoryStructurePid = super.list(
                Wrappers.<ThinktankCategoryStructure>lambdaQuery()
                .in(ThinktankCategoryStructure::getId, idSet)
                );

        //将查询的所有数据汇总到一个map中并根据id去重
        Map<String, CharacterCategoryStructureTreeVo> map = new HashMap<>();
        for (ThinktankCategoryStructure categoryStructure : characterCategoryStructure) {
            CharacterCategoryStructureTreeVo ccstvo = new CharacterCategoryStructureTreeVo();
            BeanUtils.copyProperties(categoryStructure, ccstvo);
            map.put(ccstvo.getId(), ccstvo);
        }
        for (ThinktankCategoryStructure categoryStructure : characterCategoryStructurePid) {
            CharacterCategoryStructureTreeVo ccstvo = new CharacterCategoryStructureTreeVo();
            BeanUtils.copyProperties(categoryStructure, ccstvo);
            map.put(ccstvo.getId(), ccstvo);
        }
        //所有数据的list列表
        Collection<CharacterCategoryStructureTreeVo> list =  map.values();

        List<CharacterCategoryStructureTreeVo> collect = list.stream()
                // 找出所有顶级（pid = 0 为顶级）
                .filter(o -> StrUtil.equals("0", o.getPid()))
                //给当前的父级的 children 设置子级
                .peek(o -> o.setChildren(getChildList(o, list)))
                //收集
                .collect(Collectors.toList());

        return Result.OK(collect);
    }

    @Override
    public Result<?> getAll(String category) {
        //根据名称模糊查询
        List<ThinktankCategoryStructure> characterCategoryStructure = super.list(Wrappers.<ThinktankCategoryStructure>lambdaQuery()
                .eq(StrUtil.isNotBlank(category),ThinktankCategoryStructure::getCategory,category));

        List<CharacterCategoryStructureTreeVo> list = new ArrayList<>();
        for (ThinktankCategoryStructure categoryStructure : characterCategoryStructure) {
            CharacterCategoryStructureTreeVo ccstvo = new CharacterCategoryStructureTreeVo();
            BeanUtils.copyProperties(categoryStructure, ccstvo);
            list.add(ccstvo);
        }

        List<CharacterCategoryStructureTreeVo> collect = list.stream()
                // 找出所有顶级（pid = 0 为顶级）
                .filter(o -> StrUtil.equals("0", o.getPid()))
                //给当前的父级的 children 设置子级
                .peek(o -> o.setChildren(getChildList(o, list)))
                //收集
                .collect(Collectors.toList());
        return Result.OK(collect);
    }

    @Override
    public Result<?> countryList() {
        List<Map<String, String>> list = baseMapper.countryList();
        return Result.OK(list);
    }

    // 根据当前父类 找出子类， 并通过递归找出子类的子类
    private List<CharacterCategoryStructureTreeVo> getChildList(CharacterCategoryStructureTreeVo projectLeader, Collection<CharacterCategoryStructureTreeVo> list) {
        return list.stream()
                //筛选出父节点id == parentId 的所有对象 => list
                .filter(o -> StrUtil.equals(String.valueOf(projectLeader.getId()), o.getPid()))
                .peek(o -> o.setChildren(getChildList(o, list)))
                .collect(Collectors.toList());
    }


    private void updateOldParentNode(String pid) {
        if(!LeaderCategoryService.ROOT_PID_VALUE.equals(pid)) {
            Integer count = baseMapper.selectCount(Wrappers.<ThinktankCategoryStructure>lambdaQuery().eq(ThinktankCategoryStructure::getPid,pid));
            if(count==null || count<=1) {
                super.update(Wrappers.<ThinktankCategoryStructure>lambdaUpdate().set(ThinktankCategoryStructure::getHasChild,LeaderCategoryService.NOCHILD).eq(ThinktankCategoryStructure::getId,pid));
            }
        }
    }

    /**
     * 根据所传pid查询旧的父级节点的子节点并修改相应状态值
     * @param pid
     */
    private void updateOldParentNodeDel(String pid) {
        if(!LeaderCategoryService.ROOT_PID_VALUE.equals(pid)) {
            Integer count = baseMapper.selectCount(Wrappers.<ThinktankCategoryStructure>lambdaQuery().eq(ThinktankCategoryStructure::getPid,pid));
            if(count==null || count<1) {
                super.update(Wrappers.<ThinktankCategoryStructure>lambdaUpdate().set(ThinktankCategoryStructure::getHasChild,LeaderCategoryService.NOCHILD).eq(ThinktankCategoryStructure::getId,pid));
            }
        }
    }

}
