package com.zzsn.thinktank.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;

/**
 * @Description: 标签与类别映射表
 * @Author: jeecg-boot
 * @Date:   2022-05-13
 * @Version: V1.0
 */
@Data
@TableName("sys_base_label_type_map")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class SysBaseLabelTypeMap implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    private String id;
	/**关联id(企业或其他)*/
    private String relationId;
	/**标签id*/
    private String labelId;
	/**排序号(500强企业)*/
    private Integer orderNo;
    /**标签类别（如企业、自定义等）*/
    private String labelType;
    /**创建日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private java.util.Date createTime;
}
