package com.zzsn.thinktank.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.thinktank.entity.SysBaseDomesticRegion;
import com.zzsn.thinktank.entity.SysBaseEnterprise;
import com.zzsn.thinktank.mapper.EnterpriseMapper;
import com.zzsn.thinktank.service.EnterpriseService;
import com.zzsn.thinktank.vo.Result;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/4/26 14:25
 * @Content:
 */
@Service
public class EnterpriseServiceImpl extends ServiceImpl<EnterpriseMapper, SysBaseEnterprise> implements EnterpriseService {

    @Override
    public Result<?> pageList(Integer pageNo, Integer pageSize, String socialCreditCode, String name) {
        IPage page = new Page();
        //查询列表
        Integer office = pageSize * (pageNo - 1);
        List<SysBaseEnterprise> list = baseMapper.pageList(office, pageSize, socialCreditCode, name);
        page.setRecords(list);
        //查询总数
        Integer total = baseMapper.pageListCount(socialCreditCode, name);
        page.setTotal(total);
        page.setCurrent(pageNo);
        page.setSize(pageSize);

        return Result.OK(page);
    }

    @Override
    public List<SysBaseEnterprise> getListByName(String name) {
        return baseMapper.getListByName(name);
    }
}
