package com.zzsn.thinktank.util;

import lombok.Data;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@ConfigurationProperties(prefix = "es1")
@Configuration
@Data
public class Elasticsearch1Config {
    private String endpoint1;
    private Integer endpoint1port;
    private String endpoint2;
    private Integer endpoint2port;
    private String endpoint3;
    private Integer endpoint3port;

    private String username;
    private String password;

    @Bean
    @Primary
    public RestHighLevelClient elasticsearch1Client() {
        final CredentialsProvider credentialsProvider = new BasicCredentialsProvider();

        credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(username, password));

        RestClientBuilder builder = RestClient.builder(
                new HttpHost(endpoint1, endpoint1port, "http"),
                new HttpHost(endpoint2, endpoint2port, "http"),
                new HttpHost(endpoint3, endpoint3port, "http"))
                .setHttpClientConfigCallback(httpClientBuilder -> {
                    httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
                    // 设置连接超时时间和套接字超时时间
                    RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
                    requestConfigBuilder.setConnectTimeout(300000); // 连接超时时间为300秒
                    requestConfigBuilder.setSocketTimeout(300000); // 套接字超时时间为300秒
                    httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
                    return httpClientBuilder;
                });

        return new RestHighLevelClient(builder);
    }

//    @Bean
//    public RestHighLevelClient elasticsearch1Client() {
//        final CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
//
//        credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(username, password));
//
//        RestClientBuilder builder = RestClient.builder(HttpHost.create(endpoints))
//                .setHttpClientConfigCallback(httpClientBuilder -> {
//                    httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
//                    return httpClientBuilder;
//                });
//
//        return new RestHighLevelClient(builder);
//    }
//    @Bean
//    public RestHighLevelClient elasticsearch1Client() {
//        RestHighLevelClient client = new RestHighLevelClient(
//                RestClient.builder(
//                        new HttpHost("",9200,"http"),
//                        new HttpHost("",9200,"http")
//                )
//        );
//        return client;
//
//    }
}
