package com.zzsn.thinktank.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.thinktank.entity.ThinktankCategoryStructure;
import com.zzsn.thinktank.vo.ThinktankCategoryStructureVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@Mapper
public interface LeaderCategoryMapper extends BaseMapper<ThinktankCategoryStructure> {

    @Select("select * from character_category_structure limit 10")
    List<ThinktankCategoryStructure> getListTop();

    @Select("select id,type_name from thinktank_category_structure order by CONVERT (type_name USING gbk) ASC")
    List<Map<String, String>> countryList();

    @Select("select a.*,b.thinktankCount  from thinktank_category_structure a " +
            "RIGHT JOIN (select belong_country_id,count(*) as thinktankCount  from thinktank_basic_info group by belong_country_id) b " +
            "on a.id = b.belong_country_id " +
            "where 1=1 " +
            "order by CONVERT (type_name USING gbk) ASC ")
    List<ThinktankCategoryStructureVo> lists();
}
