package com.zzsn.thinktank.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.thinktank.entity.InfoSourceGroupMap;
import com.zzsn.thinktank.entity.ThinktankBasicInfo;
import com.zzsn.thinktank.mapper.InfoSourceGroupMapMapper;
import com.zzsn.thinktank.service.InfoSourceGroupMapService;
import com.zzsn.thinktank.vo.ThinkTankSourceVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * @Description: 信息源组和信息源关联表
 * @Author:
 * @Date:
 * @Version:
 */
@Service
public class InfoSourceGroupMapServiceImpl extends ServiceImpl<InfoSourceGroupMapMapper, InfoSourceGroupMap> implements InfoSourceGroupMapService {

    @Autowired
    private InfoSourceGroupMapMapper infoSourceGroupMapMapper;

    @Override
    @Transactional //抛出异常回滚
    public String bind (String groupId, List<String> sourceIds){
        String message = "绑定成功！";
        if(!StringUtils.isEmpty(groupId) && sourceIds != null && sourceIds.size() > 0){
            for(String sourceId : sourceIds){
                //判断是否绑定过
                QueryWrapper<InfoSourceGroupMap> queryWrapper = new QueryWrapper<InfoSourceGroupMap>();
                queryWrapper.eq("group_id", groupId);
                queryWrapper.eq("source_id", sourceId);
                //todo:query in loop
                List<InfoSourceGroupMap> list = infoSourceGroupMapMapper.selectList(queryWrapper);
                if (list.size() <= 0) {
                    InfoSourceGroupMap infoSourceGroupMap = new InfoSourceGroupMap();
                    infoSourceGroupMap.setGroupId(groupId);
                    infoSourceGroupMap.setSourceId(sourceId);
                    infoSourceGroupMapMapper.insert(infoSourceGroupMap);
                } else {
                    message = "部分已经绑定信息源成功过滤，未绑定的信息源已经绑定！";
                }
            }
        }
        return message;
    }

    @Override
    public void unBind(String groupId, List<String> sourceIds){
        if(!StringUtils.isEmpty(groupId) && sourceIds != null && sourceIds.size() > 0){
            infoSourceGroupMapMapper.deleteBySourceIds(groupId, sourceIds);
        }
    }

    @Override
    public List<InfoSourceGroupMap> getSourceGroupMap(List groupIds) {

        LambdaQueryWrapper<InfoSourceGroupMap> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.in(InfoSourceGroupMap::getGroupId,groupIds);
        List<InfoSourceGroupMap> list = baseMapper.selectList(lambdaQuery);
        return list;
    }

    @Override
    public List<ThinkTankSourceVO> listOfThinkTank(List<String> groupIds) {
        return baseMapper.listOfThinkTank(groupIds);
    }

}
