package com.zzsn.thinktank.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.thinktank.entity.InfoSource;
import com.zzsn.thinktank.entity.SysDictItem;
import com.zzsn.thinktank.enums.BindTypeEnum;
import com.zzsn.thinktank.mapper.InfoSourceMapper;
import com.zzsn.thinktank.service.InfoSourceService;
import com.zzsn.thinktank.service.SysDictItemService;
import com.zzsn.thinktank.util.PageBuilderParser;
import com.zzsn.thinktank.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/4/25 9:49
 * @Content:
 */
@Service
public class InfoSourceServiceImpl extends ServiceImpl<InfoSourceMapper, InfoSource> implements InfoSourceService {

    @Autowired
    private SysDictItemService sysDictItemService;

    /**
     * 根据分类id获取信息源列表(ynBind=0 :查询没有绑定该组的信息源列表  ynBind=1 :查询绑定该组的信息源列表 )
     */
    @Override
    public IPage<InfoSourceVo> pageListByGroupId(InfoSourceVo infoSourceVo, Integer ynBind, String groupId, Integer pageNo, Integer pageSize) {
        int offset = (pageNo - 1) * pageSize;
        //查询列表
        List<InfoSourceVo> pageList = baseMapper.pageListByGroupId(infoSourceVo, ynBind, groupId, offset, pageSize);
        //获取总条数
        Integer count = baseMapper.totalCountByGroupId(infoSourceVo, ynBind, groupId);
        IPage<InfoSourceVo> pageData = new Page<>(pageNo, pageSize, count);
        pageData.setRecords(pageList);
        return pageData;
    }


    /**
     * 根据分类id获取信息源列表
     */
    @Override
    public IPage<InfoSourceVo> pageListByTypeId(String customerId, String userId, InfoSourceVo infoSourceVo, Integer pageNo, Integer pageSize, String infoSourceTypeId) {
        int offset = (pageNo - 1) * pageSize;
        //查询类别id的所有明细id
        List<String> typeIds = new ArrayList<>();
//        if (!StringUtils.isEmpty(infoSourceTypeId) && !"0".equals(infoSourceTypeId)) {
//            String ids = infoSourceTypeService.queryTreeChildLeafIds(infoSourceTypeId);
//            typeIds = Arrays.asList(ids.split(","));
//        }
        //查询列表
        long startTime1 = System.currentTimeMillis();
        List<InfoSourceVo> pageList = baseMapper.pageList(customerId,userId,infoSourceVo, typeIds, offset, pageSize);
        System.out.println("分页查询耗时::" + (System.currentTimeMillis() - startTime1));
        //build groupNames
        List<String> idList = pageList.stream().map(InfoSourceVo::getId).collect(Collectors.toList());
        if(idList.isEmpty()){
            return new Page<>(pageNo, pageSize, 0);
        }
        List<InfoSourceVo> groupNameList = baseMapper.listBySidList(customerId,userId,idList);
        Map<String, InfoSourceVo> groupNameMap = groupNameList.stream().collect(Collectors.toMap(InfoSourceVo::getSourceId, value -> value));

        //预警标签
        long startTime2 = System.currentTimeMillis();
        for (InfoSourceVo infoSourceVo1 : pageList) {
            if (null != groupNameMap.get(infoSourceVo1.getId())) {
                infoSourceVo1.setInfoSourceGroupNames(groupNameMap.get(infoSourceVo1.getId()).getInfoSourceGroupNames());
            }

            //判断该条信息源是否可以立即执行和下载（现在是定制python爬虫，并且存储方式是文件存储的支持）
            infoSourceVo1.setDownLoad(false);
            infoSourceVo1.setExecute(false);
            if (infoSourceVo1.getCrawlType() == 2) {
                //立即执行操作判断
                if (infoSourceVo1.getSetMode() == 1 && "2".equals(infoSourceVo1.getTimerMode())) {
                    infoSourceVo1.setExecute(true);
                }
                //下载判断
                if (infoSourceVo1.getDataStorageMode() == 2) {
                    infoSourceVo1.setDownLoad(true);
                }
            }
            //列表详情转换成前端格式
            reverseTransForm(infoSourceVo1);

        }
        System.out.println("数据组装耗时::" + (System.currentTimeMillis() - startTime2));
        //获取总条数
        Integer count = baseMapper.totalCount(customerId,userId,infoSourceVo, typeIds);
        IPage<InfoSourceVo> pageData = new Page<>(pageNo, pageSize, count);
        pageData.setRecords(pageList);
        return pageData;
    }

    //数据库查询时，逆向转化成前端展示结构
    private void reverseTransForm(InfoSourceVo infoSourceVo) {
        try {
            PageBuilderParser pageBuilderParser = new PageBuilderParser();
            //标题
            if (!StringUtils.isEmpty(infoSourceVo.getDetailExpressionTitle())) {
                String info = infoSourceVo.getDetailExpressionTitle();
                Document document = PageBuilderParser.xmlGetDocument(info);
                infoSourceVo.setDetailExpressionTitle(pageBuilderParser.parserStr(document, "title/exp"));
                if (!StringUtils.isEmpty(pageBuilderParser.parserStr(document, "title/attr"))) {
                    infoSourceVo.setTitleExtractionMethodType(1);
                    infoSourceVo.setTitleExtractionMethod(pageBuilderParser.parserStr(document, "title/attr"));
                } else if (!StringUtils.isEmpty(pageBuilderParser.parserStr(document, "title/subtraction"))) {
                    infoSourceVo.setTitleExtractionMethodType(2);
                    infoSourceVo.setTitleExtractionMethod(pageBuilderParser.parserStr(document, "title/subtraction"));
                }
            }
            //时间
            if (!StringUtils.isEmpty(infoSourceVo.getDetailExpressionPublishDate())) {
                String info = infoSourceVo.getDetailExpressionPublishDate();
                Document document = PageBuilderParser.xmlGetDocument(info);
                infoSourceVo.setDetailExpressionPublishDate(pageBuilderParser.parserStr(document, "publish_date/exp"));
                if (!StringUtils.isEmpty(pageBuilderParser.parserStr(document, "publish_date/attr"))) {
                    infoSourceVo.setPublishDateExtractionMethodType(1);
                    infoSourceVo.setPublishDateExtractionMethod(pageBuilderParser.parserStr(document, "publish_date/attr"));
                } else if (!StringUtils.isEmpty(pageBuilderParser.parserStr(document, "publish_date/subtraction"))) {
                    infoSourceVo.setPublishDateExtractionMethodType(2);
                    infoSourceVo.setPublishDateExtractionMethod(pageBuilderParser.parserStr(document, "publish_date/subtraction"));
                }
            }
            //作者
            if (!StringUtils.isEmpty(infoSourceVo.getDetailExpressionAuthor())) {
                String info = infoSourceVo.getDetailExpressionAuthor();
                Document document = PageBuilderParser.xmlGetDocument(info);
                infoSourceVo.setDetailExpressionAuthor(pageBuilderParser.parserStr(document, "author/exp"));
                if (!StringUtils.isEmpty(pageBuilderParser.parserStr(document, "author/attr"))) {
                    infoSourceVo.setAuthorExtractionMethodType(1);
                    infoSourceVo.setAuthorExtractionMethod(pageBuilderParser.parserStr(document, "author/attr"));
                } else if (!StringUtils.isEmpty(pageBuilderParser.parserStr(document, "author/subtraction"))) {
                    infoSourceVo.setAuthorExtractionMethodType(2);
                    infoSourceVo.setAuthorExtractionMethod(pageBuilderParser.parserStr(document, "author/subtraction"));
                }
            }
            //来源
            if (!StringUtils.isEmpty(infoSourceVo.getDetailExpressionSource())) {
                String info = infoSourceVo.getDetailExpressionSource();
                Document document = PageBuilderParser.xmlGetDocument(info);
                infoSourceVo.setDetailExpressionSource(pageBuilderParser.parserStr(document, "origin/exp"));
                if (!StringUtils.isEmpty(pageBuilderParser.parserStr(document, "origin/attr"))) {
                    infoSourceVo.setSourceExtractionMethodType(1);
                    infoSourceVo.setSourceExtractionMethod(pageBuilderParser.parserStr(document, "origin/attr"));
                } else if (!StringUtils.isEmpty(pageBuilderParser.parserStr(document, "origin/subtraction"))) {
                    infoSourceVo.setSourceExtractionMethodType(2);
                    infoSourceVo.setSourceExtractionMethod(pageBuilderParser.parserStr(document, "origin/subtraction"));
                }
            }
            //摘要
            if (!StringUtils.isEmpty(infoSourceVo.getDetailExpressionSummary())) {
                String info = infoSourceVo.getDetailExpressionSummary();
                Document document = PageBuilderParser.xmlGetDocument(info);
                infoSourceVo.setDetailExpressionSummary(pageBuilderParser.parserStr(document, "summary/exp"));
                if (!StringUtils.isEmpty(pageBuilderParser.parserStr(document, "summary/attr"))) {
                    infoSourceVo.setSummaryExtractionMethodType(1);
                    infoSourceVo.setSummaryExtractionMethod(pageBuilderParser.parserStr(document, "summary/attr"));
                } else if (!StringUtils.isEmpty(pageBuilderParser.parserStr(document, "summary/subtraction"))) {
                    infoSourceVo.setSummaryExtractionMethodType(2);
                    infoSourceVo.setSummaryExtractionMethod(pageBuilderParser.parserStr(document, "summary/subtraction"));
                }
            }
            //正文
            if (!StringUtils.isEmpty(infoSourceVo.getDetailExpressionContent())) {
                String info = infoSourceVo.getDetailExpressionContent();
                Document document = PageBuilderParser.xmlGetDocument(info);
                infoSourceVo.setDetailExpressionContent(pageBuilderParser.parserStr(document, "content/exp"));
                if (!StringUtils.isEmpty(pageBuilderParser.parserStr(document, "content/attr"))) {
                    infoSourceVo.setContentExtractionMethodType(1);
                    infoSourceVo.setContentExtractionMethod(pageBuilderParser.parserStr(document, "content/attr"));
                } else if (!StringUtils.isEmpty(pageBuilderParser.parserStr(document, "content/subtraction"))) {
                    infoSourceVo.setContentExtractionMethodType(2);
                    infoSourceVo.setContentExtractionMethod(pageBuilderParser.parserStr(document, "content/subtraction"));
                }
            }
        } catch (Exception e) {
            //
        }
    }

    @Override
    public List<String> listByGroupId(String groupId) {
        return baseMapper.listByGroupId(groupId);
    }

    @Override
    public IPage<BindInfoSourceVO> bindInfoSourcePageList(String thinkTankId, InfoSearchCondition infoSearchCondition, Integer pageNo, Integer pageSize) {
        Page<BindInfoSourceVO> page = new Page<>(pageNo, pageSize);
        return baseMapper.bindInfoSourcePageList(thinkTankId, infoSearchCondition, page);
    }

    @Override
    public IPage<BindInfoSourceColumnVO> bindInfoSourceColumnPageList(String thinkTankId, InfoSearchCondition infoSearchCondition, Integer pageNo, Integer pageSize) {
        Page<BindInfoSourceColumnVO> page = new Page<>(pageNo, pageSize);
        return baseMapper.bindInfoSourceColumnPageList(thinkTankId, infoSearchCondition, page);
    }

    @Override
    public List<BindInfoSourceColumnVO> bindInfoSourceColumnPageList(String thinkTankId, InfoSearchCondition infoSearchCondition) {
        return baseMapper.bindInfoSourceColumnPageList(thinkTankId, infoSearchCondition);
    }

    @Override
    public JSONObject bindInfoSourceGroupList(String thinkTankId) {
        JSONObject jsonObject = new JSONObject();
        List<InfoSourceGroupVO> groupList = baseMapper.bindInfoSourceGroupList(thinkTankId, BindTypeEnum.getInfoSourceMainGroupType());
        Map<Integer, List<InfoSourceGroupVO>> collect = groupList.stream().collect(Collectors.groupingBy(InfoSourceGroupVO::getSourceType));
        collect.forEach((k,v)-> {
            BindTypeEnum enumByValue = BindTypeEnum.getEnumByValue(k);
            if (ObjectUtil.isNotNull(enumByValue)) {
                //合并相同信息源组
                List<InfoSourceGroupVO> list = new ArrayList<>();
                for (InfoSourceGroupVO groupPage : v) {
                    Optional<InfoSourceGroupVO> first = list.stream().filter(f -> StrUtil.equals(f.getId(), groupPage.getId())).findFirst();
                    if(first.isPresent()){
                        InfoSourceGroupVO infoSourceGroupVO = first.get();
                        infoSourceGroupVO.setGroupTypeName(infoSourceGroupVO.getGroupTypeName()+"、"+groupPage.getGroupTypeName());
                    }else {
                        list.add(groupPage);
                    }
                }
                jsonObject.put(enumByValue.toString(), list);
            }
        });
        return jsonObject;
    }

    @Override
    public JSONObject bindInfoSourceList(String thinkTankId) {
        JSONObject jsonObject = new JSONObject();
        List<BindInfoSourceVO> infoSourceVos = baseMapper.bindInfoSourceList(thinkTankId, BindTypeEnum.getInfoSourceMainType());
        if (CollectionUtil.isEmpty(infoSourceVos)) {
            return jsonObject;
        }
        Map<Integer, List<BindInfoSourceVO>> collect = infoSourceVos.stream().collect(Collectors.groupingBy(BindInfoSourceVO::getSourceType));
        collect.forEach((k,v)-> {
            BindTypeEnum enumByValue = BindTypeEnum.getEnumByValue(k);
            if (ObjectUtil.isNotNull(enumByValue)) {
                jsonObject.put(enumByValue.toString(), v);
            }
        });
        return jsonObject;
    }

    @Override
    public JSONObject bindInfoSourceLabelList(String thinkTankId,Integer category) {
        JSONObject jsonObject = new JSONObject();
        List<Integer> typeList = null;
        if (category == 1) {
            typeList = BindTypeEnum.getInfoSourceLabelType();
        } else if (category == 2) {
            typeList = BindTypeEnum.getInfoSourceMainLabelType();
        }
        List<InfoSourceLabelVO> infoSourceLabelVOS = baseMapper.bindInfoSourceLabelList(thinkTankId, typeList);
        if (CollectionUtil.isEmpty(infoSourceLabelVOS)) {
            return jsonObject;
        }
        //字典类的标签处理层级关系
        List<String> dictCodes = infoSourceLabelVOS.stream().filter(f -> "3".equals(f.getBusinessCaliber())).map(InfoSourceLabelVO::getDictCode).collect(Collectors.toList());
        dictCodes.forEach(e -> {
            List<SysDictItem> dictList = sysDictItemService.listByDictCode(e);
            infoSourceLabelVOS.forEach(ee -> {
                if ("3".equals(ee.getBusinessCaliber())){
                    //标签使用的字典
                    Optional<SysDictItem> first = dictList.stream().filter(f -> f.getItemValue().equals(ee.getLabelItemCode())).findFirst();
                    if (first.isPresent()) {
                        SysDictItem dictItem = first.get();
                        if (StrUtil.isNotBlank(dictItem.getNames())) {
                            ee.setLabelItemName(dictItem.getNames());
                        }else{
                            ee.setLabelItemName(dictItem.getItemText());
                        }
                    }
                }
            });
        });
        Map<Integer, List<InfoSourceLabelVO>> collect = infoSourceLabelVOS.stream().collect(Collectors.groupingBy(InfoSourceLabelVO::getSourceType));
        collect.forEach((k,v)-> {
            BindTypeEnum enumByValue = BindTypeEnum.getEnumByValue(k);
            if (ObjectUtil.isNotNull(enumByValue)) {
                jsonObject.put(enumByValue.toString(), v);
            }
        });
        return jsonObject;
    }

    @Override
    public JSONObject bindInfoSourceColumnGroupList(String thinkTankId) {
        JSONObject jsonObject = new JSONObject();
        List<InfoSourceGroupVO> groupList = baseMapper.bindInfoSourceColumnGroupList(thinkTankId, BindTypeEnum.getInfoSourceGroupType());
        Map<Integer, List<InfoSourceGroupVO>> collect = groupList.stream().collect(Collectors.groupingBy(InfoSourceGroupVO::getSourceType));
        collect.forEach((k,v)-> {
            BindTypeEnum enumByValue = BindTypeEnum.getEnumByValue(k);
            if (ObjectUtil.isNotNull(enumByValue)) {
                //合并相同信息源组
                List<InfoSourceGroupVO> list = new ArrayList<>();
                for (InfoSourceGroupVO groupPage : v) {
                    Optional<InfoSourceGroupVO> first = list.stream().filter(f -> StrUtil.equals(f.getId(), groupPage.getId())).findFirst();
                    if(first.isPresent()){
                        InfoSourceGroupVO infoSourceGroupVO = first.get();
                        infoSourceGroupVO.setGroupTypeName(infoSourceGroupVO.getGroupTypeName()+"、"+groupPage.getGroupTypeName());
                    }else {
                        list.add(groupPage);
                    }
                }
                jsonObject.put(enumByValue.toString(), list);
            }
        });
        return jsonObject;
    }

    @Override
    public JSONObject bindInfoSourceColumnList(String thinkTankId) {
        List<BindInfoSourceColumnVO> infoSourceVos = baseMapper.bindInfoSourceColumnList(thinkTankId,BindTypeEnum.getInfoSourceType());
        JSONObject jsonObject = new JSONObject();
        if (CollectionUtil.isEmpty(infoSourceVos)) {
            return jsonObject;
        }
        Map<Integer, List<BindInfoSourceColumnVO>> collect = infoSourceVos.stream().collect(Collectors.groupingBy(BindInfoSourceColumnVO::getSourceType));
        collect.forEach((k,v)-> {
            BindTypeEnum enumByValue = BindTypeEnum.getEnumByValue(k);
            if (ObjectUtil.isNotNull(enumByValue)) {
                jsonObject.put(enumByValue.toString(), v);
            }
        });
        return jsonObject;
    }

    @Override
    public List<BindSourceDetailVO> bindSourceCount(List<String> thinkTankIds) {
        return baseMapper.bindSourceCount(thinkTankIds);
    }
}
