package com.zzsn.thinktank.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.thinktank.entity.*;
import com.zzsn.thinktank.mapper.ThinktankTagMapper;
import com.zzsn.thinktank.mapper.ThinktankTagTopMapper;
import com.zzsn.thinktank.service.SysBaseLabelTypeMapService;
import com.zzsn.thinktank.service.ThinktankBasicInfoService;
import com.zzsn.thinktank.service.ThinktankTagService;
import com.zzsn.thinktank.util.PinYinUtil;
import com.zzsn.thinktank.vo.Result;
import com.zzsn.thinktank.vo.SysBaseLabelTypeVo;
import com.zzsn.thinktank.vo.SysLabelVo;
import com.zzsn.thinktank.vo.ThinktankBasicInfoListVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/21 11:04
 * @Content:
 */
@Service
public class ThinktankTagServiceImpl extends ServiceImpl<ThinktankTagMapper, LabelEntity> implements ThinktankTagService {

    @Autowired
    ThinktankTagMapper thinktankTagMapper;

    @Autowired
    ThinktankTagTopMapper thinktankTagTopMapper;

    @Autowired
    ThinktankBasicInfoService thinktankBasicInfoService;

    @Autowired
    SysBaseLabelTypeMapService sysBaseLabelTypeMapService;



    @Value("${sys_base_label_type_id}")
    private String sys_base_label_type_id;
    @Value("${sys_base_label_type}")
    private String sys_base_label_type;


    @Override
    public Result<?> getTagList(String id, String name) {
        if(id == null || id.length() == 0){
            id = sys_base_label_type;
        }
        List<SysBaseLabelType> endNodes = getEndNodes(id);
        List<String> ids = new ArrayList<>();
        if (CollectionUtil.isEmpty(endNodes)){
            ids.add(id);
        }else {
            endNodes.forEach(e->ids.add(e.getId()));
        }

//        List<SysLabelVo> pageList = null;
//        pageList = baseMapper.queryCustomLabel(sysLabelVo, offset, pageSize);
        List<SysLabelVo> pageList = thinktankTagMapper.queryCustomLabel(ids,name);

        return Result.OK(pageList);
    }


    @Override
    public Result<?> getCharacterListByTag(String tagId, Integer pageNo, Integer pageSize) {
        ThinktankBasicInfoListVo thinktankBasicInfoListVo = new ThinktankBasicInfoListVo();
        thinktankBasicInfoListVo.setPageNo(pageNo);
        thinktankBasicInfoListVo.setPageSize(pageSize);
        Integer office = pageSize * (pageNo - 1);
        thinktankBasicInfoListVo.setOffset(office);
        thinktankBasicInfoListVo.setTagId(tagId);
        return thinktankBasicInfoService.getList(thinktankBasicInfoListVo);

    }


    @Override
    public void addTagTop(ThinktankTagTop thinktankTagTop){
        thinktankTagTopMapper.insert(thinktankTagTop);
    }

    @Override
    public Result<?> getTopTag() {
        List<ThinktankTagTop> list = thinktankTagMapper.getTopTag();
        return Result.OK(list);
    }

    @Override
    public SysBaseLabelTypeVo getTagTypeList() {
//        List<SysBaseLabelTypeVo> allList = new ArrayList<>();
        //SysBaseLabelTypeVo sysBaseLabelTypeVo = new SysBaseLabelTypeVo();
        //sysBaseLabelTypeVo.setId("0");
//        sysBaseLabelTypeVo.setLabelName("所有");
//        sysBaseLabelTypeVo.setPid("0");
//        sysBaseLabelTypeVo.setHasChild("1");
        List<SysBaseLabelTypeVo> list = thinktankTagMapper.getTagTypeListAll();
        //只获取人物服务相关的类别
        List<SysBaseLabelTypeVo> treeList = getBaseLabelTreeList(list,sys_base_label_type_id);
//        sysBaseLabelTypeVo.setChildren(treeList);
//        allList.add(sysBaseLabelTypeVo);
//        return allList;
        if(treeList.size()==1)
            return treeList.get(0);
        return null;
    }

    @Override
    public void addTagTop(String tagId){

        ThinktankTagTop characterTagTop = thinktankTagMapper.getById(tagId);

        if (characterTagTop == null){
            LabelEntity labelEntity = this.getById(tagId);
            ThinktankTagTop newTagTop = new ThinktankTagTop();
            newTagTop.setId(tagId);
            newTagTop.setName(labelEntity.getName());
            newTagTop.setCountNum(1);
            thinktankTagTopMapper.insert(newTagTop);
        } else {
            characterTagTop.setCountNum(characterTagTop.getCountNum() + 1);
            thinktankTagTopMapper.updateById(characterTagTop);
        }


    }

    @Override
    public List<LabelEntity> getListByIds(String[] ids) {

        LambdaQueryWrapper<LabelEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.in(LabelEntity::getId, ids);
        List<LabelEntity> list = thinktankTagMapper.selectList(lambdaQuery);

        return list;
    }

    @Override
    public void addLabel(ThinktankBasicInfo thinktankBasicInfo) {
        LabelEntity labelEntity = new LabelEntity();
        labelEntity.setId(thinktankBasicInfo.getId());
        labelEntity.setName(thinktankBasicInfo.getChineseWhole());
        labelEntity.setExplanation(thinktankBasicInfo.getChineseWhole());
        labelEntity.setPathIds(thinktankBasicInfo.getId());
        labelEntity.setStatus(1);
        labelEntity.setPid("0");
        Integer maxOrderNo = baseMapper.queryMaxOrderNo(labelEntity.getPid());
        labelEntity.setSort(maxOrderNo);
        labelEntity.setCreateTime(new Date());
        labelEntity.setHasChild("0");
        String initial = PinYinUtil.getInitialByWordMean(labelEntity.getName());
        labelEntity.setInitial(initial);
        this.save(labelEntity);

        SysBaseLabelTypeMap typeMap = new SysBaseLabelTypeMap();
        typeMap.setRelationId(thinktankBasicInfo.getId());
        typeMap.setLabelId("1806202442359099393");
        typeMap.setLabelType("custom_label");
        typeMap.setCreateTime(new Date());
        sysBaseLabelTypeMapService.save(typeMap);
    }

    @Override
    public void delLabel(List<String> ids) {
        this.removeByIds(ids);
        LambdaQueryWrapper<SysBaseLabelTypeMap> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.in(SysBaseLabelTypeMap::getRelationId, ids);
        sysBaseLabelTypeMapService.remove(lambdaQuery);
    }

    @Override
    public void editLabel(ThinktankBasicInfo thinktankBasicInfo) {
        LabelEntity labelEntity = new LabelEntity();
        labelEntity.setId(thinktankBasicInfo.getId());
        labelEntity.setName(thinktankBasicInfo.getChineseWhole());
        labelEntity.setExplanation(thinktankBasicInfo.getChineseWhole());
        labelEntity.setUpdateTime(new Date());
        String initial = PinYinUtil.getInitialByWordMean(labelEntity.getName());
        labelEntity.setInitial(initial);
        this.updateById(labelEntity);
    }


    /**
     * 根据标签类别id查询所有的末端节点
     * @param id
     * @return
     */
    public List<SysBaseLabelType> getEndNodes(String id){
        List<SysBaseLabelType> list = new ArrayList<>();

        //SysBaseLabelType byId = super.getById(id);
        SysBaseLabelType byId = thinktankTagMapper.getSysBaseLabelTypeById(id);
        if (ObjectUtil.isEmpty(byId)){
            return  list;
        }
        if ("0".equals(byId.getHasChild())){
            return list;
        }

        return getnodes(list,id);
    }

    /**
     * 递归查询
     * @param list
     * @param id
     * @return
     */
    private  List<SysBaseLabelType> getnodes(List<SysBaseLabelType> list,String id){

        //List<SysBaseLabelType> child = super.list(Wrappers.<SysBaseLabelType>lambdaQuery().eq(SysBaseLabelType::getPid, id));
        List<SysBaseLabelType> child = thinktankTagMapper.getgetSysBaseLabelTypeListByPid(id);
        child.forEach(e -> {
            if ("0".equals(e.getHasChild())){
                list.add(e);
            }else {
                getnodes(list,e.getId());
            }
        });
        return  list;
    }

    //获取树状结构
    private List<SysBaseLabelTypeVo> getBaseLabelTreeList(List<SysBaseLabelTypeVo> baseLabelTypeList, String id){
        List<SysBaseLabelTypeVo> topList = new ArrayList<>();
        baseLabelTypeList.forEach(e->{
            if (id.equals(e.getId())) {
                topList.add(e);
            }
        });
        for (SysBaseLabelTypeVo sysLabelVo : topList) {
            setBaseLabelChildren(sysLabelVo, baseLabelTypeList);
        }
        return topList;
    }
    //递归获取树形结构数据
    private void setBaseLabelChildren(SysBaseLabelTypeVo parent, List<SysBaseLabelTypeVo> list) {
        Set<SysBaseLabelTypeVo> children = getBaseLabelChildren(list, parent.getId());
        parent.setChildren(new ArrayList<>(children));
        for (SysBaseLabelTypeVo sysLabelVo : children) {
            setBaseLabelChildren(sysLabelVo, list);
        }
    }
    private Set<SysBaseLabelTypeVo> getBaseLabelChildren(List<SysBaseLabelTypeVo> list, String id) {
        Set<SysBaseLabelTypeVo> children = new HashSet<>();
        for (SysBaseLabelTypeVo sysLabelVo : list) {
            if (sysLabelVo.getPid().equals(id)) {
                children.add(sysLabelVo);
            }
        }
        return children;
    }

}






