package com.zzsn.thinktank.config.interceptor;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 数据权限拦截器
 *
 *
 */
@Component
@Slf4j
public class DataPermitInterceptor implements HandlerInterceptor {
    final String METHOD_GET="get";
    //进入controller之前执行的
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {

        if(METHOD_GET.equals(request.getMethod().toLowerCase()))
        {
            log.info("参数装配之前执行的,{},{}", JSON.toJSONString(request.getParameterNames()));

            log.info("参数装配之后执行的,{},{}", JSON.toJSONString(request.getParameterNames()));
        }else {
            log.info("参数装配之前执行的,{}", JSON.toJSONString(request.getParameterMap()));
            request.getParameterMap().put("permit",new String[]{"权限数据"});
            log.info("参数装配之后执行的,{}", JSON.toJSONString(request.getParameterMap()));
        }

        return HandlerInterceptor.super.preHandle(request, response, handler);
    }
}
