package com.zzsn.thinktank.controller;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.thinktank.entity.InfoSource;
import com.zzsn.thinktank.service.InfoSourceGroupMapService;
import com.zzsn.thinktank.service.InfoSourceService;
import com.zzsn.thinktank.vo.InfoSourceGroupPage;
import com.zzsn.thinktank.vo.InfoSourceVo;
import com.zzsn.thinktank.vo.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/4/25 9:34
 * @Content: 信息源绑定
 */
@Slf4j
@RestController
@RequestMapping("/api/bind")
public class ThinktankBindController {

    @Autowired
    private InfoSourceService infoSourceService;

    @Autowired
    private InfoSourceGroupMapService infoSourceGroupMapService;

    /**
     * 查询信息源组的绑定列表
     * @param infoSourceVo
     * @param ynBind
     * @param groupId
     * @param pageNo
     * @param pageSize
     * @return
     */
    @GetMapping(value = "/bindList")
    public Result<?> bindList(InfoSourceVo infoSourceVo,
                              @RequestParam(name="ynBind", required=true) Integer ynBind,
                              @RequestParam(name="groupId", required=true) String groupId,
                              @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
                              @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        log.info("查询信息源组的绑定列表:{}", infoSourceVo);
        log.info("信息源组id：{}---{}",groupId,pageNo);
        IPage<InfoSourceVo> pageList = infoSourceService.pageListByGroupId(infoSourceVo, ynBind, groupId, pageNo, pageSize);
        List<InfoSourceVo> list = pageList.getRecords();
        return Result.OK(pageList);
    }


    /**
     * 信息源分页列表查询
     * @param infoSourceVo
     * @param pageNo
     * @param pageSize
     * @param infoSourceTypeId
     * @return
     */
    @GetMapping(value = "/listByTypeId")
    public Result<?> queryPageListByTypeId(InfoSourceVo infoSourceVo,
                                           @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                           @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                           @RequestParam(name = "infoSourceTypeId", defaultValue = "") String infoSourceTypeId) {

        log.info("信息源分页列表查询:{}",infoSourceVo);
        IPage<InfoSourceVo> pageList = infoSourceService.pageListByTypeId(null,null,infoSourceVo, pageNo, pageSize, infoSourceTypeId);
        return Result.OK(pageList);
    }


    /**
     * 绑定信息源
     */
    @PostMapping(value = "/bind")
    public Result<?> bind(@RequestBody InfoSourceGroupPage infoSourceGroupPage) {
        log.info("绑定信息源:{}", infoSourceGroupPage);
        String message = infoSourceGroupMapService.bind(infoSourceGroupPage.getId(), infoSourceGroupPage.getInfoSourceIds());
        return Result.OK(message);
    }

    /**
     * 解绑信息源
     */
    @PostMapping(value = "/unBound")
    public Result<?> unBound(@RequestBody InfoSourceGroupPage infoSourceGroupPage) {
        log.info("解绑信息源:{}", infoSourceGroupPage);
        infoSourceGroupMapService.unBind(infoSourceGroupPage.getId(), infoSourceGroupPage.getInfoSourceIds());
        return Result.OK("解绑成功!");
    }

    /**
     * 提升信息源优先等级
     * 批量紧急
     * @param groupId 信息源组id
     * @author
     * @date
     */
    /**
     * 提升信息源优先等级
     * 批量紧急
     * @param groupId  信息源组id
     * @return
     */
    @GetMapping("/upLevel")
    public Result<?> upLevel(@RequestParam("groupId") String groupId){
        log.info("批量紧急:{}", groupId);
        List<String> sourceIdList = infoSourceService.listByGroupId(groupId);
        LambdaUpdateWrapper<InfoSource> update = Wrappers.lambdaUpdate();
        update.set(InfoSource::getSiteLevel,1).in(InfoSource::getId,sourceIdList);
        infoSourceService.update(update);
        return Result.OK();
    }

}
