package com.zzsn.leaderbase.service.impl;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.leaderbase.entity.CharacterCategoryStructure;
import com.zzsn.leaderbase.entity.CharacterChangeInfo;
import com.zzsn.leaderbase.mapper.LeaderCategoryMapper;
import com.zzsn.leaderbase.service.CharacterChangeInfoService;
import com.zzsn.leaderbase.service.LeaderCategoryService;
import com.zzsn.leaderbase.vo.CharacterCategoryStructureTreeVo;
import com.zzsn.leaderbase.vo.Result;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *  分类树服务实现类
 * </p>
 *
 * @author
 * @since
 */
@Service
public class LeaderCategoryServiceImpl extends ServiceImpl<LeaderCategoryMapper, CharacterCategoryStructure> implements LeaderCategoryService {

    @Autowired
    CharacterChangeInfoService characterChangeInfoService;

    @Override
    @Transactional
    public Result<?> add(CharacterCategoryStructure characterCategoryStructure) {
        //判断是否有父节点，没有则为根节点，pid的值为0
        if (StringUtils.isBlank(characterCategoryStructure.getPid())){
            characterCategoryStructure.setPid(LeaderCategoryService.ROOT_PID_VALUE);
        }else {
            CharacterCategoryStructure parent = super.getById(characterCategoryStructure.getPid());
            if(parent!=null && !LeaderCategoryService.HASCHILD.equals(parent.getHasChild())){
                parent.setHasChild(LeaderCategoryService.HASCHILD);
                super.updateById(parent);
            }
        }
        //characterCategoryStructure.setStatus(0);
        characterCategoryStructure.setHasChild(LeaderCategoryService.NOCHILD);
        /**第一次保存赋默认值*/
        characterCategoryStructure.setFullPath("0");
        characterCategoryStructure.setCreateTime(new Date());
        super.save(characterCategoryStructure);
        if (LeaderCategoryService.ROOT_PID_VALUE.equals(characterCategoryStructure.getPid())){
            characterCategoryStructure.setFullPath(characterCategoryStructure.getId());
        }else {
            CharacterCategoryStructure parent = super.getById(characterCategoryStructure.getPid());
            characterCategoryStructure.setFullPath(parent.getFullPath() +","+ characterCategoryStructure.getId());
        }
        super.updateById(characterCategoryStructure);
        return Result.OK();
    }


    @Override
    @Transactional
    public Result<?> edit(CharacterCategoryStructure characterCategoryStructure) {
        CharacterCategoryStructure byId = super.getById(characterCategoryStructure.getId());
        if (ObjectUtils.isEmpty(byId)){
            return Result.error("未找到对应的分类id");
        }
        String oldPid = byId.getPid();
        String newPid = characterCategoryStructure.getPid();
        if(!oldPid.equals(newPid)) {
            /**处理之前父节点的hasChild字段*/
            updateOldParentNode(oldPid);

            if(StringUtils.isBlank(newPid) || LeaderCategoryService.ROOT_PID_VALUE.equals(newPid)){
                characterCategoryStructure.setPid(LeaderCategoryService.ROOT_PID_VALUE);
                newPid = characterCategoryStructure.getPid();
            }
            /**处理新的父节点的hasChild字段*/
            if(!LeaderCategoryService.ROOT_PID_VALUE.equals(characterCategoryStructure.getPid())) {
                super.update(Wrappers.<CharacterCategoryStructure>lambdaUpdate().set(CharacterCategoryStructure::getHasChild,LeaderCategoryService.HASCHILD).eq(CharacterCategoryStructure::getId,newPid));
            }
            characterCategoryStructure.setUpdateTime(new Date());
            super.updateById(characterCategoryStructure);


            /**处理本节点的所有子节点的绝对路径*/
            List<CharacterCategoryStructure> list = super.list(Wrappers.<CharacterCategoryStructure>lambdaQuery().like(CharacterCategoryStructure::getFullPath,characterCategoryStructure.getId()));
            if (CollectionUtil.isNotEmpty(list)){
                String finalNewPid = newPid;
                if (!LeaderCategoryService.ROOT_PID_VALUE.equals(finalNewPid)) {
                    /**非根节点 移动到其他非根节点*/
                    CharacterCategoryStructure projectPid = super.getById(finalNewPid);

                    if (!LeaderCategoryService.ROOT_PID_VALUE.equals(oldPid)) {
                        String id = characterCategoryStructure.getId();
                        String fullPath = characterCategoryStructure.getFullPath();
                        String replace = fullPath.replace(id, "");

                        list.forEach(e->{
                            e.setFullPath(projectPid.getFullPath()+"," + e.getFullPath().replace(replace, ""));
                        });
                    }else {
                        /**根节点 移动到其他非根节点*/
                        list.forEach(e->{
                            e.setFullPath(projectPid.getFullPath()+","+e.getFullPath());
                        });
                    }
                }else {
                    String id = characterCategoryStructure.getId();
                    String fullPath = characterCategoryStructure.getFullPath();
                    String replace = fullPath.replace(id, "");
                    /**移动到根节点*/
                    list.forEach(e->{
                        e.setFullPath(e.getFullPath().replace(replace, ""));
                    });
                }
            }
            super.updateBatchById(list);
        }else {
            characterCategoryStructure.setUpdateTime(new Date());
            super.updateById(characterCategoryStructure);
        }
        return Result.OK();

    }

    @Override
    public Result<?> del(String id) {
        CharacterCategoryStructure byId = super.getById(id);
        super.remove(Wrappers.<CharacterCategoryStructure>lambdaQuery().like(CharacterCategoryStructure::getFullPath,id));
        if (StringUtils.isNotBlank(byId.getPid())&&!LeaderCategoryService.ROOT_PID_VALUE.equals(byId.getPid())){
            updateOldParentNodeDel(byId.getPid());
        }

        //删除分类时，需要情况该分类下关联的人物  单号 2759 人物所在类别删除后，展示异常
        UpdateWrapper<CharacterChangeInfo> wrapper = new UpdateWrapper<>();
        wrapper.set("type_id",null);  //设置字段值为null
        wrapper.in("type_id",id);
        characterChangeInfoService.update(null,wrapper);  //更新   默认忽略null，所以实体类传的null，然后执行后面的条件和内容

        return Result.OK();
    }


    @Override
    public Result<?> lists(String sign, String pid, String category) {

            List<CharacterCategoryStructure> characterCategoryStructure ;
            if ("1".equals(sign)&&"0".equals(pid)){
                characterCategoryStructure = super.list(Wrappers.<CharacterCategoryStructure>lambdaQuery()
                        .eq(CharacterCategoryStructure::getPid, LeaderCategoryService.ROOT_PID_VALUE)
                        .eq(StrUtil.isNotBlank(category),CharacterCategoryStructure::getCategory,category));
            }else {
                characterCategoryStructure = super.list(Wrappers.<CharacterCategoryStructure>lambdaQuery()
                        .eq(CharacterCategoryStructure::getPid,pid)
                        .eq(StrUtil.isNotBlank(category),CharacterCategoryStructure::getCategory,category));
            }
            return Result.OK(characterCategoryStructure);

    }

    @Override
    public Result<?> getByName(String category, String typeName) {
        //根据名称模糊查询
        List<CharacterCategoryStructure> characterCategoryStructure = super.list(Wrappers.<CharacterCategoryStructure>lambdaQuery()
                .like(CharacterCategoryStructure::getTypeName,typeName)
                .eq(StrUtil.isNotBlank(category),CharacterCategoryStructure::getCategory,category));

        //根据所有子节点的pid路径查询所有父节点
        Set<String> idSet = new HashSet<>();
        for (CharacterCategoryStructure categoryStructure : characterCategoryStructure) {
            String fullPath = categoryStructure.getFullPath();
            String[] pidArr = fullPath.split(",");
            idSet.addAll(Arrays.asList(pidArr));
        }
        List<CharacterCategoryStructure> characterCategoryStructurePid = super.list(
                Wrappers.<CharacterCategoryStructure>lambdaQuery()
                .in(CharacterCategoryStructure::getId, idSet)
                );

        //将查询的所有数据汇总到一个map中并根据id去重
        Map<String, CharacterCategoryStructureTreeVo> map = new HashMap<>();
        for (CharacterCategoryStructure categoryStructure : characterCategoryStructure) {
            CharacterCategoryStructureTreeVo ccstvo = new CharacterCategoryStructureTreeVo();
            BeanUtils.copyProperties(categoryStructure, ccstvo);
            map.put(ccstvo.getId(), ccstvo);
        }
        for (CharacterCategoryStructure categoryStructure : characterCategoryStructurePid) {
            CharacterCategoryStructureTreeVo ccstvo = new CharacterCategoryStructureTreeVo();
            BeanUtils.copyProperties(categoryStructure, ccstvo);
            map.put(ccstvo.getId(), ccstvo);
        }
        //所有数据的list列表
        Collection<CharacterCategoryStructureTreeVo> list =  map.values();

        List<CharacterCategoryStructureTreeVo> collect = list.stream()
                // 找出所有顶级（pid = 0 为顶级）
                .filter(o -> StrUtil.equals("0", o.getPid()))
                //给当前的父级的 children 设置子级
                .peek(o -> o.setChildren(getChildList(o, list)))
                //收集
                .collect(Collectors.toList());

        return Result.OK(collect);
    }

    @Override
    public Result<?> getAll(String category) {
        //根据名称模糊查询
        List<CharacterCategoryStructure> characterCategoryStructure = super.list(Wrappers.<CharacterCategoryStructure>lambdaQuery()
                .eq(StrUtil.isNotBlank(category),CharacterCategoryStructure::getCategory,category));

        List<CharacterCategoryStructureTreeVo> list = new ArrayList<>();
        for (CharacterCategoryStructure categoryStructure : characterCategoryStructure) {
            CharacterCategoryStructureTreeVo ccstvo = new CharacterCategoryStructureTreeVo();
            BeanUtils.copyProperties(categoryStructure, ccstvo);
            list.add(ccstvo);
        }

        List<CharacterCategoryStructureTreeVo> collect = list.stream()
                // 找出所有顶级（pid = 0 为顶级）
                .filter(o -> StrUtil.equals("0", o.getPid()))
                //给当前的父级的 children 设置子级
                .peek(o -> o.setChildren(getChildList(o, list)))
                //收集
                .collect(Collectors.toList());
        return Result.OK(collect);
    }

    // 根据当前父类 找出子类， 并通过递归找出子类的子类
    private List<CharacterCategoryStructureTreeVo> getChildList(CharacterCategoryStructureTreeVo projectLeader, Collection<CharacterCategoryStructureTreeVo> list) {
        return list.stream()
                //筛选出父节点id == parentId 的所有对象 => list
                .filter(o -> StrUtil.equals(String.valueOf(projectLeader.getId()), o.getPid()))
                .peek(o -> o.setChildren(getChildList(o, list)))
                .collect(Collectors.toList());
    }


    private void updateOldParentNode(String pid) {
        if(!LeaderCategoryService.ROOT_PID_VALUE.equals(pid)) {
            Integer count = baseMapper.selectCount(Wrappers.<CharacterCategoryStructure>lambdaQuery().eq(CharacterCategoryStructure::getPid,pid));
            if(count==null || count<=1) {
                super.update(Wrappers.<CharacterCategoryStructure>lambdaUpdate().set(CharacterCategoryStructure::getHasChild,LeaderCategoryService.NOCHILD).eq(CharacterCategoryStructure::getId,pid));
            }
        }
    }

    /**
     * 根据所传pid查询旧的父级节点的子节点并修改相应状态值
     * @param pid
     */
    private void updateOldParentNodeDel(String pid) {
        if(!LeaderCategoryService.ROOT_PID_VALUE.equals(pid)) {
            Integer count = baseMapper.selectCount(Wrappers.<CharacterCategoryStructure>lambdaQuery().eq(CharacterCategoryStructure::getPid,pid));
            if(count==null || count<1) {
                super.update(Wrappers.<CharacterCategoryStructure>lambdaUpdate().set(CharacterCategoryStructure::getHasChild,LeaderCategoryService.NOCHILD).eq(CharacterCategoryStructure::getId,pid));
            }
        }
    }

}
