package com.zzsn.leaderbase.kafka;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zzsn.leaderbase.entity.CharacterExtractInfo;
import com.zzsn.leaderbase.service.CharacterExtractInfoService;
import com.zzsn.leaderbase.service.IGeneratorIdService;
import com.zzsn.leaderbase.util.EsUtil;
import com.zzsn.leaderbase.util.HttpUtil;
import com.zzsn.leaderbase.vo.BaseData;
import com.zzsn.leaderbase.vo.InfoExtractionParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 人物职务变更数据接收
 */
@Component
@Slf4j
public class PersonOfJobChangeKafkaConsumer {

    @Value("${python.getInfoUrl}")
    private String relationEntityUrl;

    @Autowired
    CharacterExtractInfoService characterExtractInfoService;

    @Autowired
    IGeneratorIdService generatorIdService;

    @Autowired
    private EsUtil esUtil;

    private String USERSERVER_BASEDATA = "userserver_basedata";


    @KafkaListener(topics = "personOfJobChangeTopic", groupId = "group02")
    public void listen(String message) {
        log.info("kafka pull personOfJobChangeTopic: {} ......", message.substring(0,30));
        getData(message);
    }

    public void getData(String message) {
        //log.info(message);
        InfoExtractionParam record = JSON.parseObject(message, InfoExtractionParam.class);
        BaseData baseData = JSON.parseObject(message, BaseData.class);
        log.info("create_date:{}---title:{}",baseData.getCreateDate(),baseData.getTitle());
        if(StringUtils.isEmpty(baseData.getId())){
            String id = String.valueOf(generatorIdService.getId());
            baseData.setId(id);
        }

        List<CharacterExtractInfo> list = new ArrayList<>();
        Map<String, List<InfoExtractionParam>> map = new HashMap<>();
        map.put("data_list", Collections.singletonList(record));
        JSONObject jsonObjectParam = new JSONObject();
        jsonObjectParam.put("data", map);
        JSONArray dataResultList = null;
        try {
            log.info("request");
            String result = HttpUtil.doPost(relationEntityUrl, jsonObjectParam, 40000);
            log.info("response:{}", result);
            Object objectResult = parseResult(result);
            if (null != objectResult) {
                dataResultList = (JSONArray) JSONArray.parse(objectResult.toString());
            }
        }catch (Exception e){
            log.error("异常：{}",e.getMessage());
        }
        if (dataResultList != null && dataResultList.size() > 0) {
            esUtil.docSaveByEntity(USERSERVER_BASEDATA, baseData.getId(), baseData);
            for (Object dataResultObject : dataResultList) {
                JSONObject dataResult = JSONObject.parseObject(dataResultObject.toString());
                if (dataResult.get("infos") != null) {
                    JSONArray jsonArray = (JSONArray) JSONArray.parse(String.valueOf(dataResult.get("infos")));
                    for (Object data : jsonArray) {
                        JSONObject temp = JSONObject.parseObject(data.toString());

                        //判重
                        String curStation = temp.get("curStation") != null ? temp.get("curStation").toString() : "";
                        String curWorkPlace = temp.get("curWorkPlace") != null ? temp.get("curWorkPlace").toString() : "";
                        String person = temp.get("person") != null ? temp.get("person").toString() : "";
                        boolean b = characterExtractInfoService.deduplication(curStation,curWorkPlace,person);
                        if(b){
                            log.info("数据重复：{}",data.toString());
                        } else {
                            String id = Long.toString(generatorIdService.getOrderId());
                            list.add(CharacterExtractInfo.builder()
                                    .id(id)
                                    .name(temp.get("person") != null ? temp.get("person").toString() : "")
                                    .department(temp.get("curWorkPlace") != null ? temp.get("curWorkPlace").toString() : "")
                                    .duty(temp.get("curStation") != null ? temp.get("curStation").toString() : "")
                                    .departmentOriginal(temp.get("oriWorkPlace") != null ? temp.get("oriWorkPlace").toString() : "")
                                    .dutyOriginal(temp.get("oriStation") != null ? temp.get("oriStation").toString() : "")
                                    .updateDesc(temp.get("updateDesc") != null ? temp.get("updateDesc").toString() : "")
                                    .articleIndex(USERSERVER_BASEDATA)
                                    .articleId(baseData.getId())
                                    .articleTitle(baseData.getTitle())
                                    .articleOrigin(baseData.getOrigin())
                                    .checkStatus(0)
                                    .createTime(new Date())
                                    .build()
                            );
                        }
                    }
                }
            }
        }
        if (!list.isEmpty()) {
            characterExtractInfoService.addBulk(list);
        }
    }

    private Object parseResult(String result) {
        JSONObject jsonObject = JSONObject.parseObject(result);
        if (null != jsonObject && "true".equals(jsonObject.getString("isHandleSuccess"))) {
            return jsonObject.get("resultData");

        }
        log.error("python 服务结果异常，响应信息{}", result);
        return null;
    }

}