package com.zzsn.leaderbase.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.zzsn.leaderbase.vo.*;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 10:11
 * @Content:
 */
public interface CharacterInfoService {

    Result<?> add(CharacterVo characterVo);

    Result<?> addBulk (List<CharacterVo> list);

    Result<?> getByUid(String uid);

    Result<?> getById(String id);

    Result<?> edit(CharacterVo characterVo);

    Result<?> del(String id);

    Result<?> getList(CharacterListVo characterListVo);


    /**
     * 根据 根据职位 工作单位 姓名去重
     * curStation, curWorkPlace, person
     * duty, company, name
     *
     * 有重复数据时返回true
     * 没有重复数据时返回false
     * @param curStation
     * @param curWorkPlace
     * @param person
     * @return
     */
    boolean deduplication(String curStation, String curWorkPlace, String person);

    Result<?> checkList(String articleId, String[] checkResultArr);

    Result<?> getListByName(String id, String Name, String articleId);

    Result<?> merge(CharacterMergeVo characterMergeVo);

    Result<?> mergeCancel(String id);

    Result<?> getPreviousDuty(String uid);

    Result<?> correlation(CharacterVo characterVo);

    Result<?> correlationEdit(CharacterVo characterVo);
}

