package com.zzsn.leaderbase.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Builder;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@Builder
@TableName("character_extract_info")
public class CharacterExtractInfo {

  //主键
  private String id;
  //人物名称
  private String name;
  //性别
  private String sex;
  //部门 单位 企业(现)
  private String department;
  //职务(现)
  private String duty;
  //部门 单位 企业(原)
  private String departmentOriginal;
  //职务(原)
  private String dutyOriginal;
  //变更描述
  private String updateDesc;
  //关联资讯索引名称
  private String articleIndex;
  //关联资讯id
  private String articleId;
  //资讯标题
  private String articleTitle;
  //资讯发布时间
  private String articleDate;
  //资讯来源
  private String articleOrigin;
  //审核状态  1已审核 0未审核
  private Integer checkStatus;
  //创建时间
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  //更新时间
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date updateTime;

}
