package com.zzsn.leaderbase.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 10:00
 * @Content: 人物操作vo
 * 人物基本信息和职务变更信息分开存储
 * 人物基本信息，每次修改都再历史表中记录
 * 人物职务变更信息，只有再点击变更时再历史表中记录，只修改时不记录
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CharacterVo {

    /**
     * 基本信息
     */
    //主键
    private String id;
    //人物id
    private String uid;
    //人物名称
    private String name;
    //性别
    private String sex;
    //出生地
    private String birthplace;
    //出生日期
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date birthday;
    //籍贯
    private String nativePlace;
    //毕业院校
    private String school;
    //专业
    private String speciality;
    //学历
    private String education;
    //职业
    private String expertOccupation;
    //头像
    private String headSculpture;
    //个人简历 简介
    private String biographicalNotes;
    //分类类型:领导人、专家、企业高管
    private String category;
    //任职经历，每一条任职经历用 \n（换行）分割
    private String awardRecords;
    //社会兼职，每一条用 \n（换行） 分割
    private String partTimeJob;
    //研究领域
    private String researchField;
    //荣誉评价
    private String evaluate;
    //创建人
    private String createBy;
    //创建时间
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    //更新人
    private String updateBy;
    //更新时间
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
    //启停状态  1启 0停
    private Long status;

    /**
     * 职务变更信息
     */
    //原单位
    private String companyOriginal;
    //原部门 原单位 原企业
    private String departmentOriginal;
    //原职务
    private String dutyOriginal;
    //单位(现)
    private String company;
    //部门 单位 企业(现)
    private String department;
    //职务(现)
    private String duty;
    //任职时间
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date takeOfficeTime;
    //任职结束时间
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date takeOfficeTimeEnd;
    //任职状态
    private String takeOfficeStatus;
    //变更链接
    private String changeUrl;
    //职务变更时间
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date dutiesUpdateTime;
    //职务变更原因
    private String dutiesUpdateReason;
    //是否审核  1是 0否
    private Long checkStatus;
    //是否审核通过 0未通过 1通过 2待定 -1未审核
    private Long checkResult;
    //关联资讯id
    private String articleId;
    //关联资讯标题
    private String articleTitle;
    //变更描述
    private String updateDesc;

    //审核信息 原人物id
    private String originalId;
    //审核信息 新人物id
    private String newId;
    //合并结果 0手动新增 1合并人物  2新增人物  3追加历任职务  -1取消操作
    private Long mergeStatus;

}
