package com.zzsn.leaderbase.config;

import com.zzsn.leaderbase.service.UserInfoExecutorService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/15 11:49
 * @Content:
 */
@Slf4j
@Component
public class UserInfoExecutor implements CommandLineRunner {

    @Autowired
    UserInfoExecutorService userInfoExecutorService;

    ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    private final Integer PERIOD=60;

    @Override
    public void run(String... args) {
        scheduledExecutorService.scheduleAtFixedRate(()->{
            userInfoExecutorService.run();
        },5,PERIOD, TimeUnit.SECONDS);
        log.info("发送人物名称到redis定时任务启动成功！{}---{}执行一次",PERIOD,TimeUnit.SECONDS);
    }
}
