package com.zzsn.leaderbase.kafka;

import com.zzsn.leaderbase.service.UserInfoRedisExecutorService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

/**
 * 从kafka中拉取从百度采集到的任务信息
 */
@Component
@Slf4j
public class UserServerCharacterInfoKafkaConsumer {

    @Autowired
    UserInfoRedisExecutorService userInfoRedisExecutorService;
 
    @KafkaListener(topics = "userserver_character_info", groupId = "group04")
    public void listen(String message) {
        log.info("kafka pull userserver_character_info: {} ......", message.substring(0,300));
        userInfoRedisExecutorService.run(message);
    }
}