package com.zzsn.leaderbase.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.entity.CharacterBasicInfoHistory;
import com.zzsn.leaderbase.entity.CharacterChangeInfo;
import com.zzsn.leaderbase.service.*;
import com.zzsn.leaderbase.util.CharacterMergeStatus;
import com.zzsn.leaderbase.vo.CharacterCheckVo;
import com.zzsn.leaderbase.vo.CharacterListVo;
import com.zzsn.leaderbase.vo.CharacterVo;
import com.zzsn.leaderbase.vo.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 10:13
 * @Content: 人物基本信息和职务变更信息
 */
@Service
@Slf4j
public class CharacterInfoServiceImpl implements CharacterInfoService {

    @Autowired
    CharacterBasicInfoService characterBasicInfoService;
    @Autowired
    CharacterBasicInfoHistoryService characterBasicInfoHistoryService;

    @Autowired
    CharacterChangeInfoService characterChangeInfoService;
    @Autowired
    CharacterChangeInfoHistoryService characterChangeInfoHistoryService;

    //生成id
    @Autowired
    IGeneratorIdService generatorIdService;
    @Autowired
    CharacterMergeStatus characterMergeStatus;


    @Override
    public Result<?> add(CharacterVo characterVo) {

        String id = Long.toString(generatorIdService.getOrderId());
        characterVo.setId(id);
        characterVo.setCreateTime(new Date());

        String uid = generatorIdService.getIdNo();
        characterVo.setUid(uid);

        //vo对象获取转entity对象，基本信息
        CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
        BeanUtils.copyProperties(characterVo, characterBasicInfo);
        characterBasicInfoService.save(characterBasicInfo);

        //vo对象获取转entity对象，任职变更信息
        CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
        BeanUtils.copyProperties(characterVo, characterChangeInfo);
        characterChangeInfoService.save(characterChangeInfo);

        //记录任务基本信息修改记录
        CharacterBasicInfoHistory characterBasicInfoHistory = new CharacterBasicInfoHistory();
        BeanUtils.copyProperties(characterBasicInfo, characterBasicInfoHistory);
        characterBasicInfoHistory.setId(null);
        characterBasicInfoHistoryService.save(characterBasicInfoHistory);

        return Result.OK();
    }

    @Override
    public Result<?> addBulk(List<CharacterVo> list) {

        List<CharacterBasicInfo> characterBasicInfoList = new ArrayList<>();
        List<CharacterChangeInfo> characterChangeInfoList = new ArrayList<>();
        List<CharacterBasicInfoHistory> characterBasicInfoHistoryList = new ArrayList<>();
        for (CharacterVo characterVo : list) {
            String id = Long.toString(generatorIdService.getOrderId());
            characterVo.setId(id);
            characterVo.setCreateTime(new Date());
            String uid = generatorIdService.getIdNo();
            characterVo.setUid(uid);

            CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
            BeanUtils.copyProperties(characterVo, characterBasicInfo);
            characterBasicInfoList.add(characterBasicInfo);

            CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
            BeanUtils.copyProperties(characterVo, characterChangeInfo);
            characterChangeInfoList.add(characterChangeInfo);

            CharacterBasicInfoHistory characterBasicInfoHistory = new CharacterBasicInfoHistory();
            BeanUtils.copyProperties(characterBasicInfo, characterBasicInfoHistory);
            characterBasicInfoHistory.setId(null);
            characterBasicInfoHistoryList.add(characterBasicInfoHistory);
        }

        characterBasicInfoService.saveBatch(characterBasicInfoList);
        characterChangeInfoService.saveBatch(characterChangeInfoList);
        characterBasicInfoHistoryService.saveBatch(characterBasicInfoHistoryList);

        return Result.OK();
    }

    @Override
    public Result<?> getByUid(String uid) {
        return Result.OK(characterBasicInfoService.getByUid(uid));
    }

    @Override
    public Result<?> getById(String id) {
        return Result.OK(characterBasicInfoService.getById(id));
    }

    @Override
    public Result<?> edit(CharacterVo characterVo) {

        characterVo.setUpdateTime(new Date());

        //vo对象获取转entity对象，基本信息
        CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
        BeanUtils.copyProperties(characterVo, characterBasicInfo);
        characterBasicInfoService.updateById(characterBasicInfo);

        //vo对象获取转entity对象，任职变更信息
        CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
        BeanUtils.copyProperties(characterVo, characterChangeInfo);
        characterChangeInfoService.updateById(characterChangeInfo);

        //记录人物基本信息修改记录
        CharacterBasicInfoHistory characterBasicInfoHistory = new CharacterBasicInfoHistory();
        BeanUtils.copyProperties(characterBasicInfo, characterBasicInfoHistory);
        characterBasicInfoHistory.setId(null);
        characterBasicInfoHistory.setCreateTime(new Date());
        characterBasicInfoHistoryService.save(characterBasicInfoHistory);

        return Result.OK();
    }

    @Override
    public Result<?> del(String id) {

        characterBasicInfoService.removeById(id);
        characterChangeInfoService.removeById(id);
        return Result.OK();
    }

    @Override
    public Result<?> getList(CharacterListVo characterListVo) {
        IPage page = new Page();

        //根据条件查询数据
        List<CharacterVo> list = characterBasicInfoService.getList(characterListVo);

        page.setRecords(list);
        //查询总数
        Integer total = characterBasicInfoService.getCount(characterListVo);
        page.setTotal(total);
        Integer pageNo = characterListVo.getPageNo();
        Integer pageSize= characterListVo.getPageSize();
        page.setCurrent(pageNo);
        page.setSize(pageSize);

        return Result.OK(page);
    }


    @Override
    public Result<?> checkList(String articleId) {

        List<CharacterVo> list = new ArrayList<>();
        //当关联多个资讯id时时使用逗号分隔的
        String[] articleIdsArr = articleId.split(",");
        for (String article : articleIdsArr) {
            List<CharacterVo> characterVoList = characterBasicInfoService.checkList(article);
            list.addAll(characterVoList);
        }
        return Result.OK(list);
    }

    @Override
    public Result<?> getListByName(String id, String name, String articleId) {

        List<CharacterVo> list = characterBasicInfoService.getListByName(id, name, articleId);

        return Result.OK(list);

    }

    @Override
    public Result<?> checkUpdate(CharacterCheckVo characterCheckVo) {

        //原人物信息
        CharacterVo originalCharacter = characterCheckVo.getOriginalCharacter();
        //新人物信息
        CharacterVo character = characterCheckVo.getCharacter();
        character.setCheckStatus(1L);

        //更新职务信息
        //获取新的人物对象
        CharacterVo characterVoNew = characterMergeStatus.mergeNew(originalCharacter, character);


        //保存数据
        //vo对象获取转entity对象，基本信息
        CharacterBasicInfo characterBasicInfo = new CharacterBasicInfo();
        BeanUtils.copyProperties(characterVoNew, characterBasicInfo);
        characterBasicInfoService.save(characterBasicInfo);

        //vo对象获取转entity对象，任职变更信息
        CharacterChangeInfo characterChangeInfo = new CharacterChangeInfo();
        BeanUtils.copyProperties(characterVoNew, characterChangeInfo);
        characterChangeInfoService.save(characterChangeInfo);

        //合并前的数据状态修改为停用
        List<CharacterChangeInfo> updateList = new ArrayList<>();
        CharacterChangeInfo cci1 = new CharacterChangeInfo();
        cci1.setId(originalCharacter.getId());
        cci1.setStatus(0L);
        updateList.add(cci1);
        CharacterChangeInfo cci2 = new CharacterChangeInfo();
        cci2.setId(character.getId());
        cci2.setStatus(0L);
        updateList.add(cci2);
        characterChangeInfoService.updateBatchById(updateList);

        //记录人物基本信息修改记录
        CharacterBasicInfoHistory characterBasicInfoHistory = new CharacterBasicInfoHistory();
        BeanUtils.copyProperties(characterBasicInfo, characterBasicInfoHistory);
        characterBasicInfoHistory.setId(null);
        characterBasicInfoHistoryService.save(characterBasicInfoHistory);

        return Result.OK(characterVoNew);
    }

    @Override
    public Result<?> checkCancelUpdate(String id) {
        //根据id查询人物信息
        CharacterVo characterVo = characterBasicInfoService.getById(id);
        if(characterVo == null){
            log.info("根据id未查询到人物信息：{}", id);
            return Result.error("未查询到人物信息!");
        }
        //审核信息 原人物id
        String originalId = characterVo.getOriginalId();
        //审核信息 新人物id
        String newId = characterVo.getNewId();
        //审核信息 1:更新人物  2:添加职位
        Long mergeStatus = characterVo.getMergeStatus();
        if (mergeStatus == null || originalId == null || newId == null){
            log.info("数据有误：{}---{}---{}", originalId, newId, mergeStatus);
            return Result.error("数据有误！");
        }
        //恢复合并前的人物为启用
        //合并前的数据状态修改为停用
        List<CharacterChangeInfo> updateList = new ArrayList<>();
        CharacterChangeInfo cci1 = new CharacterChangeInfo();
        cci1.setId(originalId);
        cci1.setStatus(1L);
        characterChangeInfoService.updateById(cci1);
        updateList.add(cci1);
        CharacterChangeInfo cci2 = new CharacterChangeInfo();
        cci2.setId(newId);
        cci2.setStatus(1L);
        updateList.add(cci2);
        characterChangeInfoService.updateById(cci1);

        //characterChangeInfoService.updateBatchById(updateList);

        //删除合并人物
        characterBasicInfoService.removeById(id);
        characterChangeInfoService.removeById(id);

        //查询新人物返回
        CharacterVo characterById = characterBasicInfoService.getById(newId);
        return Result.OK(characterById);
    }

}
