package com.zzsn.leaderbase.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

@Data
public class SysBaseLabelTypeVo {
    /**主键*/
    private String id;
    /**标签名称*/
    private String labelName;
    /**标签标识*/
    private String labelMark;
    /**说明*/
    private String explanation;
    /**创建人*/
    private String createBy;
    /**创建日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private java.util.Date createTime;
    /**更新人*/
    private String updateBy;
    /**更新日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private java.util.Date updateTime;
    /**所属部门*/
    private String sysOrgCode;
    /**父级节点*/
    private String pid;
    /**是否有子节点*/
    @Excel(name = "是否有子节点", width = 15, dicCode = "yn")
    private String hasChild;
    /**排序*/
    private Integer orderNo;
    /**顶层id*/
    private String topId;
    /**标签类别（如企业、自定义等）*/
    private String labelType;
    /**下级节点*/
    private java.util.List<SysBaseLabelTypeVo> children;
}
