package com.zzsn.leaderbase.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 人物基本信息表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("character_basic_info")
public class CharacterBasicInfo extends Model<CharacterBasicInfo> {
  private static final long serialVersionUID = 1L;

  //主键
  @TableId(value = "id", type = IdType.ASSIGN_ID)
  private String id;
  //人物id
  private String uid;
  //人物名称
  private String name;
  //性别
  private String sex;
  //出生地
  private String birthplace;
  //出生日期
  private String birthday;
  //民族
  private String nation;
  //籍贯
  private String nativePlace;
  //毕业院校
  private String school;
  //专业
  private String speciality;
  //学历
  private String education;
  //职业
  private String expertOccupation;
  //头像
  private String headSculpture;
  //个人简历 简介
  private String biographicalNotes;
  //分类类型(1-领导人、2-专家、3-企业高管)
  private String category;
  //类别id 和左侧树进行关联
  private String typeId;
  //部门 单位 企业
  private String department;
  //职务
  private String duty;
  //部门 单位 企业(原)
  private String departmentOriginal;
  //职务(原)
  private String dutyOriginal;
  //任职时间
  private String takeOfficeTime;
  //任职结束时间
  private String takeOfficeTimeEnd;
  //任职状态 历任 现任
  private String takeOfficeStatus;
  //变更描述
  private String updateDesc;
  //关联资讯索引名称
  private String articleIndex;
  //关联资讯id
  private String articleId;
  //资讯标题
  private String articleTitle;
  //资讯来源
  private String articleOrigin;
  //关联资讯抽取表id
  private String extractId;
  //标签id
  private String tagId;
  //标签名称
  private String tagName;
  //统一社会信用代码
  private String socialCreditCode;
  //排序
  private Integer sort;
  //是否主条目(1-主条目；0-非主条目)
  private Integer mainEntry;

  //顶尖专家/领军专家
  private String expertType;
  //研究领域
  private String researchField;
  //已选入的人才计划
  private String talentPlanning;
  //专业技术职称
  private String technicalTitles;
  //专业技术职称取得时间
  private String technicalDate;
  //参加工作时间
  private String workDate;

  //毕业专业
  private String schoolSpeciality;
  //所在部门
  private String depart;

  //创建人
  private String createBy;
  //创建时间
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  //更新人
  private String updateBy;
  //更新时间
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date updateTime;
  //启停状态  1启 0停
  private Long status;
  //有没有历任数据 1-有；0-没有
  @TableField(exist = false)
  private Integer hasChild;
  //关键词
  @TableField(exist = false)
  private String keyword;
}
