package com.zzsn.leaderbase.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.leaderbase.entity.CharacterBasicInfo;
import com.zzsn.leaderbase.mapper.CharacterBasicInfoMapper;
import com.zzsn.leaderbase.service.CharacterBasicInfoService;
import com.zzsn.leaderbase.vo.CharacterListVo;
import com.zzsn.leaderbase.vo.CharacterVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/29 10:35
 * @Content: 人物基本信息
 */
@Service
public class CharacterBasicInfoServiceImpl extends ServiceImpl<CharacterBasicInfoMapper, CharacterBasicInfo> implements CharacterBasicInfoService {

    @Autowired
    CharacterBasicInfoMapper characterBasicInfoMapper;

    @Override
    public CharacterVo getByUid(String uid) {

        return characterBasicInfoMapper.getByUid(uid);
    }

    @Override
    public CharacterVo getById(String id) {
        return characterBasicInfoMapper.getById(id);
    }

    @Override
    public List<CharacterVo> getList(CharacterListVo characterListVo) {
        List<CharacterVo> list = characterBasicInfoMapper.getList(characterListVo);
        return list;
    }

    @Override
    public Integer getCount(CharacterListVo characterListVo) {
        return characterBasicInfoMapper.getCount();
    }
}
