package com.zzsn.leaderbase.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * kafka接收数据实体
 */
@Data
public class BaseData implements Serializable {
    //说明：...Raw 表示原文，即原语言
    //作者
    private String author;
    private String authorRaw;
    //正文
    private String content;
    private String contentRaw;
    //带标签正文
    private String contentWithTag;
    private String contentWithTagRaw;
    //入库时间
    private String createDate;
    //信息来源id(信息源或者关键词)
    private String sid;
    //语言
    private String lang;
    private String langRaw;
    //来源（信息来源）
    private String origin;
    private String originRaw;
    //发布时间
    private String publishDate;
    //发布地址
    private String sourceAddress;
    //摘要
    private String summary;
    private String summaryRaw;
    //关键词
    private String keyWords;
    //标题
    private String title;
    private String titleRaw;
    //采集来源（如通用、定制、微信公众号等）
    private String source;
    //附加字段
    private String type;

    //视频下载链接
    private String downLoadUrl;
    //视频链接（原链接 网页版）
    private String videoUrl;
    //视频链接（原链接 手机版）
    private String videoPhoneUrl;
    //视频时长单位秒
    private Long videoTime;
    //视频第一帧图片
    private String videoImg;
    //重复id
    private String repeatId;
    private String subjectId;
    //快照地址
    private String screenShotImg;
    //id
    private String id;
    //信息类别（1：报刊  2：博客  3：客户端  4：论坛  5：视频  6：外媒  7：网站  8：微博  9：微信  10：新闻  11：政务  12：其它）
    private String infoSourceType;

    //资讯关联的附件id
    private List<String> attachmentIds;

}
