package com.zzsn.leaderbase.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lkg
 * @description: 企业高管表
 * @date 2023/1/9
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class Executive implements Serializable {

    private String id;
    /**企业统一社会信用代码*/
    private String socialCreditCode;
    /**高管姓名*/
    private String name;
    /**性别*/
    private String sex;
    /**学历*/
    private String education;
    /**职位*/
    private String position;
    /**薪资*/
    private String salary;
    /**出生年份*/
    private Integer birthYear;
    /**持股数*/
    private String shareNum;
    /**持股比例*/
    private String shareRatio;
    /**最终受益股份*/
    private String benefitShare;
    /**本届任期*/
    private String currentTerm;
    /**个人简介*/
    private String personInfo;
    /**排序*/
    private Integer sort;
    /**创建时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;

}
